% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfidx.R
\name{idx_name}
\alias{idx_name}
\alias{idx_name.dfidx}
\alias{idx_name.idx}
\alias{idx_name.xseries}
\title{Get the names of the indexes}
\usage{
idx_name(x, n = 1, m = NULL)

\method{idx_name}{dfidx}(x, n = NULL, m = NULL)

\method{idx_name}{idx}(x, n = NULL, m = NULL)

\method{idx_name}{xseries}(x, n = NULL, m = NULL)
}
\arguments{
\item{x}{a \code{dfidx}, a \code{idx} or a \code{xseries} object}

\item{n}{the index to be extracted (1 or 2, ignoring the nesting
variables)}

\item{m}{if > 1, a nesting variable}
}
\value{
if \code{n} is \code{NULL}, a named integer which gives the posititon
of the \code{idx} column in the \code{dfidx} object, otherwise, a
character of length 1
}
\description{
This function extract the names of the indexes or the name of a
specific index
}
\examples{
if (requireNamespace("mlogit")){
data("JapaneseFDI", package = "mlogit")
JapaneseFDI <- dplyr::select(JapaneseFDI, 1:8)
JP1b <- dfidx(JapaneseFDI, idx = list("firm", c("region", "country")),
idnames = c("japf", "iso80"))
# get the position of the idx column
idx_name(JP1b)
# get the name of the first index
idx_name(JP1b, 1)
# get the name of the second index
idx_name(JP1b, 2)
# get the name of the nesting variable for the second index
idx_name(JP1b, 2, 2)
}
}
\author{
Yves Croissant
}
