% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calc_hf}
\alias{calc_hf}
\title{Calculate hafnium values.}
\usage{
calc_hf(dat, constants)
}
\arguments{
\item{dat}{data.frame, list or matrix of hafnium values}

\item{constants}{vector of constants which must be in the order
decay constant 176Lu, 176/177Hf CHUR, 176Lu/177Hf CHUR, 176/177Hf DM,
176Lu/177Hf DM and 176Lu/177Hf value used for two-stage depleted mantle
model age calculations}
}
\description{
Calculates the initial 176Hf/177Hf values, the initial epsilon hafnium
values, the model age using the measured 176Lu/177Hf value and
the model age assuming the parental magma was produced from an average continental crust
(176Lu/177Hf = 0.015) that originally was derived from the depleted mantle
(Griffin, 2004).
}
\references{
Bouvier, A., Vervoort, J.D. & Patchett, P.J. 2008.
The Lu-Hf and Sm-Nd isotopic composition of CHUR:
Constraints from unequilibrated chondrites and implications for the bulk composition of terrestrial planets.
Earth And Planetary Science Letters 273(1-2), 48-57.

Griffin, W., Belousova, E., Shee, S., Pearson, N. and O'Reilly, S. 2004.
Archean crustal evolution in the northern Yilgam Craton:
U-Pb and Hf-isotope evidence from detrital zircons. Precambrian Research, 231-282.

Soderlund, U., Patchett, J., Vervoort, J. & Isachsen, C. 2004.
The Lu-176 decay constant determined by Lu-Hf and U-Pb isotope systematics of Precambrian mafic intrusions.
Earth And Planetary Science Letters 219(3-4), 311-324.
}
