% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{apply_on_pillars}
\alias{apply_on_pillars}
\title{Apply a function to each pillar of a 3-dimensional array.}
\usage{
apply_on_pillars(arr3d, FUN)
}
\arguments{
\item{arr3d}{A 3-dimensional array.}

\item{FUN}{A function which takes a vector as input and, for a given input
length, outputs a vector of constant length (can be 1).}
}
\value{
If \code{FUN} is returning length 1 vectors, a matrix whereby
\code{mat[i, j] = FUN(arr3d[i, j, ])}. If FUN is returning vectors of
length \code{l > 1}, a 3-dimensional array whereby \code{arr[i, j, ] =
  FUN(arr3d[i, j, ])}.
}
\description{
Define a 'pillar' of a 3-dimensional array as pillar \verb{i,j} off array
\code{arr} being \code{arr[i, j, ]}. This function applies a specified
function to each pillar.
}
