% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myrs.R
\name{rfromboxes}
\alias{rfromboxes}
\title{Randomly draw balls from boxes.}
\usage{
rfromboxes(n, balls, weights = NULL)
}
\arguments{
\item{n}{A natural number. The number of balls to draw.}

\item{balls}{A vector of natural numbers. The number of balls in each box to
begin with.}

\item{weights}{A non-negative numeric vector the same length as \code{balls}. The
relative probabilities of drawing a ball from each box. Default is each box
is equally likely to be drawn from.}
}
\value{
A vector of natural numbers with the same length as \code{balls}. The
number of balls drawn from each box.
}
\description{
Given a number of boxes with a specified number of balls in each, randomly
draw a number of balls from these boxes, recording how many balls was drawn
from each. An empty box cannot be drawn from.
}
\examples{
balls <- 1:10
rfromboxes(40, balls)
rfromboxes(40, balls, weights = c(rep(1, 9), 0))

}
\seealso{
rtoboxes
}
