% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar_stats.R
\name{pillar-stats}
\alias{pillar-stats}
\alias{mean_pillars}
\alias{median_pillars}
\alias{var_pillars}
\title{Get the means/medians/variances of pillars of a 3d array.}
\usage{
mean_pillars(arr3d, parallel = FALSE)

median_pillars(arr3d, parallel = FALSE)

var_pillars(arr3d, parallel = FALSE)
}
\arguments{
\item{arr3d}{A 3-dimensional array.}

\item{parallel}{Do you want to parallelize the computation across multiple
cores? If so, set this to the number of cores that you would like to use,
or set it to \code{TRUE} to use all available cores.}
}
\value{
A matrix where element \code{i,j} is equal to
\code{mean(mat3d[i, j, ])}, \code{median(mat3d[i, j, ])}, or
\code{var(mat3d[i, j, ])}.
}
\description{
For a 3-dimensional array \code{mat3d}, pillar \code{ij} is defined as
\code{mat3d[i, j, ]}. These functions compute the mean, median and variance
of each pillar.
}
\examples{
aaa <- array(1:16, dim = c(2, 2, 4))
mean_pillars(aaa)
median_pillars(aaa)
var_pillars(aaa)

}
