% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asiangeomavg.R
\name{geomavgstrike}
\alias{geomavgstrike}
\title{Geometric average-strike options}
\usage{
geomavgstrike(s, km, v, r, tt, d, m, cont=FALSE)
}
\arguments{
\item{s}{Stock price}

\item{km}{The strike mutiplier, relative to the initial stock
price, for an average price payoff. If the initial stock price
is \code{s = 120} and \code{km = 115}, the payoff for an
average strike call is \deqn{Payoff = max(ST - km/s*SAvg, 0)}.}

\item{v}{Volatility of the stock, defined as the annualized
standard deviation of the continuously-compounded return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{cont}{Boolean which when TRUE denotes continuous averaging}
}
\value{
Vector of call and put prices for geometric average strike
    options
geomavgstrike(s, km, v, r, tt, d, m)
}
\description{
Prices of geometric average-strike call and put options
}
\examples{
s=40; km=40; v=0.30; r=0.08; tt=0.25; d=0; m=3;
}
\seealso{
Other Asian: \code{\link{arithasianmc}},
  \code{\link{arithavgpricecv}}, \code{\link{geomasianmc}},
  \code{\link{geomavgprice}}
}

