% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels.hclust}
\alias{labels.hclust}
\title{Find labels of hclust object (in dendrogram order)}
\usage{
\method{labels}{hclust}(object, ...)
}
\arguments{
\item{object}{hclust object from which to extract labels}

\item{...}{Additional arguments (ignored)}
}
\value{
character vector of labels in dendrogram order
}
\description{
NB will return labels in dendrogram order, not in the
order of the original labels retained in object$labels
ususally corresponding to the row or column names of 
the \code{\link{dist}} object provided to \code{\link{hclust}}.
}
\examples{
hc <- hclust(dist(USArrests), "ave")
dend <- as.dendrogram(hc)
stopifnot(all.equal(labels(hc),labels(dend)))
}
\seealso{
\code{\link{labels},\link{hclust}}
}
\author{
jefferis
}
