% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demogdata.R
\name{demogdata}
\alias{demogdata}
\title{####################################################
Create demogdata object from raw data matrices}
\usage{
demogdata(data, pop, ages, years, type, label, name, lambda)
}
\arguments{
\item{data}{Matrix of data: either mortality rates or fertility rates}

\item{pop}{Matrix of population values of same dimension as data. 
These are population numbers as at 30 June of each year (i.e., the "exposures"). 
So, for example, the number of deaths is data*pop if data contains mortality rates.}

\item{ages}{Vector of ages corresponding to rows of \code{data}.}

\item{years}{Vector of years corresponding to columns of \code{data}.}

\item{type}{Character string showing type of demographic series:
either \dQuote{mortality}, \dQuote{fertility} or \dQuote{migration}.}

\item{label}{Character string of the name of area from which the data are taken.}

\item{name}{Name of series: usually male, female or total.}

\item{lambda}{Box-Cox transformation parameter.}
}
\value{
Object of class \dQuote{demogdata} with the following components:
\item{year}{Vector of years}
\item{age}{Vector of ages}
\item{rate}{A list containing one or more rate matrices with one age group per row and one column per year.}
\item{pop}{A list of the same form as \code{rate} but containing population numbers instead of demographic rates.}
\item{type}{Type of object: \dQuote{mortality}, \dQuote{fertility} or \dQuote{migration}.}
\item{label}{label}
\item{lambda}{lambda}
}
\description{
Create demogdata object suitable for plotting using \code{\link{plot.demogdata}} and
fitting an LC or BMS model using \code{\link{lca}} or an FDA model using \code{\link{fdm}}.
}
\seealso{
\code{\link{read.demogdata}}
}
\author{
Rob J Hyndman
}
\keyword{manip}
