% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_color.R
\docType{data}
\name{facet_nested_color}
\alias{facet_nested_color}
\alias{FacetNestedColor}
\title{Layout panels in a grid with nested colored strips}
\usage{
facet_nested_color(
  rows = NULL,
  cols = NULL,
  scales = "fixed",
  space = "fixed",
  axes = "margins",
  remove_labels = "none",
  independent = "none",
  shrink = TRUE,
  labeller = "label_value",
  colors = stages,
  lab_colors = "auto",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE,
  margins = FALSE,
  nest_line = element_line(inherit.blank = TRUE),
  solo_line = FALSE,
  resect = unit(0, "mm"),
  render_empty = TRUE,
  strip = strip_nested(),
  bleed = NULL
)
}
\arguments{
\item{rows, cols}{A set of variables or expressions quoted by
\code{\link[ggplot2:vars]{vars()}} and defining faceting groups on the rows or columns
dimension. The variables can be named (the names are passed to
\code{labeller}).

For compatibility with the classic interface, \code{rows} can also be
a formula with the rows (of the tabular display) on the LHS and
the columns (of the tabular display) on the RHS; the dot in the
formula is used to indicate there should be no faceting on this
dimension (either row or column).}

\item{scales}{A \code{character(1)} or \code{logical(1)} whether scales are shared
across facets or allowed to vary. Interacts with the \code{independent}
argument. One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{Scales are shared across all facets
(default).}
\item{\code{"free_x"}}{x-scales are allowed to vary across rows.}
\item{\code{"free_y"}}{y-scales are allowed to vary across columns.}
\item{\code{"free"} or \code{TRUE}}{Scales can vary across rows and columns.}
}}

\item{space}{A \code{character(1)} or \code{logical(1)} determining whether the size of
panels are proportional to the length of the scales. When the \code{independent}
argument allows for free scales in a dimension, the panel sizes cannot be
proportional. Note that the \code{scales} argument must be free in the same
dimension as the \code{space} argument to have an effect.One of the following:
\describe{
\item{\code{"fixed"} or \code{FALSE}}{All panels have the same size (default).}
\item{\code{"free_x"}}{Panel widths are proportional to the x-scales.}
\item{\code{"free_y"}}{Panel heights are proportional to the y-scales.}
\item{\code{"free"} or \code{TRUE}}{Both the widths and heights vary according to
scales.}
}}

\item{axes}{A \code{character(1)} or \code{logical(1)} where axes should be drawn. One
of the following:
\describe{
\item{\code{"margins"} or \code{FALSE}}{Only draw axes at the outer margins
(default).}
\item{\code{"x"}}{Draw axes at the outer margins and all inner x-axes too.}
\item{\code{"y"}}{Draw axes at the outer margins and all inner y-axes too.}
\item{\code{"all"} or \code{TRUE}}{Draw the axes for every panel.}
}}

\item{remove_labels}{A \code{character(1)} or \code{logical(1)} determining whether
axis text is displayed at inner panels. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{Display axis text at all axes (default).}
\item{\code{"x"}}{Display axis text at outer margins and all inner y-axes.}
\item{\code{"y"}}{Display axis text at outer margins and all inner x-axes.}
\item{\code{"all"} or \code{TRUE}}{Only display axis text at the outer margins.}
}}

\item{independent}{A \code{character(1)} or \code{logical(1)} determining whether
scales can vary within a row or column of panels, like they can be in
\link[ggplot2:facet_wrap]{ggplot2::facet_wrap}. The \code{scales} argument must be free for the same
dimension before they can be set to independent. One of the following:
\describe{
\item{\code{"none"} or \code{FALSE}}{All y-scales should be fixed in a row and all
x-scales are fixed in a column (default).}
\item{\code{"x"}}{x-scales are allowed to vary within a column.}
\item{\code{"y"}}{y-scales are allowed to vary within a row.}
\item{\code{"all"} or \code{TRUE}}{Both x- and y-scales are allowed to vary within
a column or row respectively.}
}}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{colors}{Specifies which colors to use to replace the strip backgrounds.
Either A) a function that returns a color for a given strip label, B) the
character name of a function that does the same, C) a named character
vector with names matching strip labels and values indicating the desired
colors, or D) a data.frame representing a lookup table with columns named
"name" (matching strip labels) and "color" (indicating desired colors). If
the function returns \code{NA}, the default background color will be used.}

\item{lab_colors}{Specifies which colors to use for the strip labels. Either
A) a function that returns a color for a given strip label, B) the
character name of a function that does the same, C) a named character
vector with names matching strip labels and values indicating the desired
colors, D) a data.frame representing a lookup table with columns named
"name" (matching strip labels) and "lab_color" (indicating desired colors),
or E) "auto" (the default), which set the labels to black or white,
whichever has better contrast with the background color, based on
\href{https://www.itu.int/rec/R-REC-BT.601-7-201103-I/en}{recommendations by the International Telecommunication Union}.
If the function returns \code{NA}, the default label color will be used.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{nest_line}{a theme element, either \code{element_blank()} or inheriting
from \code{\link[ggplot2:element]{ggplot2::element_line()}}. Lines are drawn between layers of strips
indicating hierarchy. The element inherits from the
\code{\link[ggh4x:theme_extensions]{ggh4x.facet.nestline}} element in the theme.}

\item{solo_line}{A \code{logical(1)} indicating whether parent strips with a
single child should be drawn with a \code{nest_line} (\code{TRUE}) or the line only
applies to parents with multiple children (\code{FALSE}, default). Only relevant
when \code{nest_line} is drawn.}

\item{resect}{a \code{unit} vector of length 1, indicating how much the
nesting line should be shortened.}

\item{render_empty}{A \code{logical(1)}: whether to draw panels without any data
(\code{TRUE}, default) or display these as blanks (\code{FALSE}).}

\item{strip}{An object created by a call to a strip function, such as
\code{\link[ggh4x:strip_nested]{strip_nested()}}.}

\item{bleed}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} the \code{bleed} argument has
moved to the \code{strip_nested()} function.}
}
\description{
\code{facet_nested_color} behaves similarly to \code{\link[ggh4x:facet_nested]{ggh4x::facet_nested()}} in that it
forms a matrix of panels defined by row and column faceting variables and
nests grouped facets. The main difference is that it also allows the user to
specify the background and label colors of the individual facet strips using
the \code{colors} and \code{lab_colors} arguments.
}
\details{
This function inherits the capabilities of
\code{\link[ggh4x:facet_grid2]{facet_grid2()}}.

Unlike \code{facet_grid()}, this function only automatically expands
missing variables when they have no variables in that direction, to allow
for unnested variables. It still requires at least one layer to have all
faceting variables.

Hierarchies are inferred from the order of variables supplied to
\code{rows} or \code{cols}. The first variable is interpreted to be the
outermost variable, while the last variable is interpreted to be the
innermost variable. They display order is always such that the outermost
variable is placed the furthest away from the panels. For more information
about the nesting of strips, please visit the documentation of
\code{\link[ggh4x:strip_nested]{strip_nested()}}.
}
\examples{
library(ggplot2)
df <- data.frame(x = 1:10, y = 1:10,
                 period = factor(c("Permian", "Triassic", "Jurassic",
                                   "Cretaceous", "Paleogene"),
                                 levels = c("Permian", "Triassic",
                                            "Jurassic", "Cretaceous",
                                            "Paleogene")),
                 era = factor(c("Paleozoic", "Mesozoic", "Mesozoic",
                                "Mesozoic", "Cenozoic"),
                                levels = c("Paleozoic", "Mesozoic",
                                           "Cenozoic")))
ggplot(df, aes(x, y)) +
  geom_point() +
  facet_nested_color(~ era + period, colors = rbind(periods, eras))
}
\seealso{
Other faceting functions: 
\code{\link{facet_grid_color}()},
\code{\link{facet_nested_wrap_color}()},
\code{\link{facet_wrap_color}()}
}
\concept{faceting functions}
\keyword{datasets}
