% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_color.R
\docType{data}
\name{facet_wrap_color}
\alias{facet_wrap_color}
\alias{FacetWrapColor}
\title{Wrap a 1d ribbon of panels into 2d with colored strips}
\usage{
facet_wrap_color(
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  colors = stages,
  as.table = TRUE,
  drop = TRUE,
  dir = "h",
  strip.position = "top",
  axes = "margins",
  axis.labels = "all"
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{nrow, ncol}{Number of rows and columns.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:label_parsed]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:label_value]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{colors}{Specifies which colors to use to replace the strip backgrounds.
Either A) a function that returns a color for a given strip label, B) the
character name of a function that does the same, C) a named character
vector with names matching strip labels and values indicating the desired
colors, or D) a data.frame representing a lookup table with columns named
"name" (matching strip labels) and "color" (indicating desired colors). If
the function returns}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either \code{"h"} for horizontal, the default, or \code{"v"},
for vertical.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}

\item{axes}{Determines which axes will be drawn in case of fixed scales. When
\code{"margins"} (default), axes will be drawn at the exterior margins.
\code{"all_x"} and \code{"all_y"} will draw the respective axes at the interior
panels too, whereas \code{"all"} will draw all axes at all panels. Only works
for ggplot2 version 3.5.0 and later.}

\item{axis.labels}{Determines whether to draw labels for interior axes when
the scale is fixed and the \code{axis} argument is not \code{"margins"}. When \code{"all"}
(default), all interior axes get labels. When \code{"margins"}, only the
exterior axes get labels, and the interior axes get none. When \code{"all_x"} or
\code{"all_y"}, only draws the labels at the interior axes in the x- or
y-direction respectively. Only works for ggplot2 version 3.5.0 and later.}
}
\description{
\code{facet_wrap_color} behaves similarly to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} in that it
wraps a 1d sequence of panels into 2d. The main difference is that it also
allows the user to specify the background colors of the individual facet
strips using the \code{colors} argument. This is generally a better use of screen
space than \code{\link[=facet_grid_color]{facet_grid_color()}} because most displays are roughly
rectangular.
}
\examples{
library(ggplot2)
df <- data.frame(x = 1:10, y = 1:10, period = c("Permian", "Triassic"))
ggplot(df) +
  geom_point(aes(x, y)) +
  facet_wrap_color(vars(period), colors = periods)
}
\keyword{datasets}
