% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deep_mou_gibbs.R
\name{deep_mou_gibbs}
\alias{deep_mou_gibbs}
\title{Deep Mixture of Unigrams}
\usage{
deep_mou_gibbs(x, k, g, n_it = 500, seed_choice = 1, burn_in = 200)
}
\arguments{
\item{x}{Document-term matrix describing the frequency of terms that occur in a collection of documents. Rows correspond to documents in the collection and columns correspond to terms.}

\item{k}{Number of clusters/groups at the top layer.}

\item{g}{Number of clusters at the bottom layer.}

\item{n_it}{Number of Gibbs steps.}

\item{seed_choice}{Set seed for reproducible results.}

\item{burn_in}{Number of initial Gibbs samples to be discarded and not included in the computation of final estimates.}
}
\value{
A list containing the following elements:
\item{x}{The data matrix.}
\item{clusters}{the clustering labels.}
\item{k}{the number of clusters at the top layer.}
\item{g}{the number of clusters at the bottom layer.}
\item{numobs}{the sample size.}
\item{p}{the vocabulary size.}
\item{z1}{the allocation variables at the top layer.}
\item{z2}{the allocation variables at the bottom layer.}
\item{Alpha}{the estimates of Alpha parameters.}
\item{Beta}{the estimates of the Beta parameters.}
\item{pi_hat}{estimated probabilities of belonging to the \code{k} clusters at the top layer conditional to the \code{g} clusters at the bottom layer.}
\item{pi_hat_2}{estimated probabilities of belonging to the \code{g} clusters at the bottom layer.}
}
\description{
Performs parameter estimation by means of Gibbs sampling and cluster allocation
for the Deep Mixture of Unigrams.
}
\details{
Starting from the data matrix \code{x}, the Deep Mixture of Unigrams is fitted
and \code{k} clusters are obtained.
The algorithm for the estimation of the parameters is the Gibbs sampling.
In particular, the function assigns initial values to all the parameters to be estimated. Then \code{n_it} samples for the parameters are obtained using
conditional distributions on all the other parameters. The final estimates are obtained by averaging the samples given that initial \code{burn_in} samples are
discarded. Clustering is eventually performed by maximizing the posterior distribution of the latent variables.
For further details see the references.
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering, very few iterations used for this example
deep_CNAE2 = deep_mou_gibbs(x = CNAE2, k = 2, g = 2, n_it = 5, burn_in = 2)

# Shows cluster labels to documents
deep_CNAE2$clusters
}
\references{
Viroli Cinzia, Anderlucci Laura (2020). "Deep mixtures of Unigrams for uncovering topics in textual data". \emph{Statistics and Computing}, forthcoming, 1-18.
}
