% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_keyvalue.R
\docType{data}
\name{rc}
\alias{rc}
\alias{sjukhus_rc}
\alias{forvaltning_rc}
\title{Codes used by RC's kvartalen}
\description{
Key-value codes for VGR hospitals and organizational units according to RC.
 
 Function \code{sjukhus_rc_namn} and \code{forvaltning_rc_namn}
 (see\code{\link{extra_functions}}) can be 
 used to translate codes into text, see examples below.
}
\examples{
 # From RCC hospital code to RC hospital code
 decode(51012, "sjukhus_rc")
 
 # From RCC code to RC name
 decode(51012, "sjukhus_rc", "sjukhus_rc_namn")
 
 # From RCC hospital code to RC organizational unit code
 decode(51012, "forvaltning_rc")
 
 # From RCC code to RC name
 decode(51012, "forvaltning_rc", "forvaltning_rc_namn")
     
}
\seealso{
See the vignette \code{vignette("RC_units", "decoder")} 
 for more details and examples (Swedish).

Other key_value_data: \code{\link{distrikt}},
  \code{\link{figo}}, \code{\link{forsamling}},
  \code{\link{hemort}}, \code{\link{hsn}},
  \code{\link{icd10}}, \code{\link{icd7_grov}},
  \code{\link{icd7}}, \code{\link{icd9}},
  \code{\link{icdo3_grov}}, \code{\link{icdo3}},
  \code{\link{icdo}}, \code{\link{klinik}},
  \code{\link{kommun}}, \code{\link{kon}},
  \code{\link{lan}}, \code{\link{m_rtr}},
  \code{\link{n_rtr}}, \code{\link{pad}},
  \code{\link{patologiavdelning}}, \code{\link{region}},
  \code{\link{sida}}, \code{\link{sjukhus_inca}},
  \code{\link{sjukhus_par}}, \code{\link{sjukhus}},
  \code{\link{sjukvardsomrade}}, \code{\link{snomed3}},
  \code{\link{snomed}}, \code{\link{t_rtr}},
  \code{\link{tnmgrund}}
}
\concept{key_value_data}
\keyword{datasets}
