% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_sbmeff.R
\name{model_sbmeff}
\alias{model_sbmeff}
\title{Slack based measure (SBM) of efficiency model.}
\usage{
model_sbmeff(datadea,
            dmu_eval = NULL,
            dmu_ref = NULL,
            weight_input = 1,
            weight_output = 1,
            orientation = c("no", "io", "oo"),
            rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
            L = 1,
            U = 1,
            compute_target = TRUE,
            returnlp = FALSE,
            ...)
}
\arguments{
\item{datadea}{The data, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.}

\item{weight_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne} (where \code{ne} is the lenght of \code{dmu_eval})
with weights to inputs corresponding to the relative importance of items.}

\item{weight_output}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne} (where \code{ne} is the lenght of \code{dmu_eval})
with weights to outputs corresponding to the relative importance of items.}

\item{orientation}{A string, equal to "no" (non-oriented), "io" (input-oriented) or "oo" (output-oriented).}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{compute_target}{Logical. If it is \code{TRUE}, it computes targets.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems (objective function and constraints).}

\item{...}{Other options (currently not implemented)}
}
\description{
Calculate the SBM model proposed by Tone (2001).
}
\examples{
# Replication of results in Tone (2001, p.505)
data("Tone2001")
data_example <- read_data(Tone2001, 
                          ni = 2, 
                          no = 2)
result_SBM <- model_sbmeff(data_example, 
                           orientation = "no", 
                           rts = "crs")
result_CCR <- model_basic(data_example, 
                          orientation = "io", 
                          rts = "crs")
efficiencies(result_SBM)
efficiencies(result_CCR)
slacks(result_SBM)
slacks(result_CCR)
 
}
\references{
Tone, K. (2001). "A Slacks-Based Beasure of Efficiency in Data Envelopment Analysis", European Journal of Operational Research, 130, 498-509. \url{https://doi.org/10.1016/S0377-2217(99)00407-5}

Cooper, W.W.; Seiford, L.M.; Tone, K. (2007). Data Envelopment Analysis. A Comprehensive Text with Models, Applications, References and DEA-Solver Software. 2nd Edition. Springer, New York. \url{https://doi.org/10.1007/978-0-387-45283-8}
}
\seealso{
\code{\link{model_nonradial}}, \code{\link{model_deaps}}, \code{\link{model_deaps}}, \code{\link{model_sbmsupereff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
