% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lol_to_df}
\alias{lol_to_df}
\title{Convert a list of lists returned from vapply to a dataframe}
\usage{
lol_to_df(lol, name = "well")
}
\arguments{
\item{lol}{List of lists that is a result of a vapply}

\item{name}{Column name to use for the name of each list}
}
\description{
When running a \code{vapply} function and each element returns a list with
multiple values, the return value is a list of lists.  This function can be
used to convert that return value into a data.frame.
}
\examples{
vapply(c("a", "b", "c"),
       function(x) list(low = x, up = toupper(x)),
       list(character(1), character(1))) \%>\%
  lol_to_df("key")
}
\seealso{
\code{\link[ddpcr]{named_vec_to_df}}
}
\keyword{internal}
