% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-custom_thresholds.R
\name{plot.custom_thresholds}
\alias{plot.custom_thresholds}
\title{Plot a ddPCR plate of type custom thresholds}
\usage{
\method{plot}{custom_thresholds}(x, wells, samples, ...,
  show_thresholds = TRUE, col_thresholds = "black",
  show_drops_empty = TRUE, col_drops_x_positive = "green3",
  col_drops_y_positive = "blue", col_drops_both_positive = "orange")
}
\arguments{
\item{x}{A ddPCR plate.}

\item{wells}{Only plot selected wells. Supports range notation, see
\code{\link[ddpcr]{subset.ddpcr_plate}}.}

\item{samples}{Only plot selected samples.}

\item{...}{Parameters to pass to \code{\link[ddpcr]{plot.ddpcr_plate}}.}

\item{show_thresholds}{If \code{TRUE}, show the thresholds.}

\item{col_thresholds}{The colour of the threshold lines.}

\item{show_drops_empty}{Whether or not to show the droplets defined as empty.}

\item{col_drops_x_positive}{The colour to use for droplets that are in the
X+Y- quadrant.}

\item{col_drops_y_positive}{The colour to use for droplets that are in the
X-Y+ quadrant.}

\item{col_drops_both_positive}{The colour to use for droplets that are in the
X+Y+ quadrant.}
}
\value{
A ggplot2 plot object.
}
\description{
Same plot as \code{\link[ddpcr]{plot.ddpcr_plate}} but with a few extra
features that are specific to plates with custom thresholds. Take a look
at \code{\link[ddpcr]{plot.ddpcr_plate}} to see all supported parameters
and more information.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
plate \%>\% set_thresholds(c(5500, 8000)) \%>\% analyze \%>\% plot
}
}
\seealso{
\code{\link[ddpcr]{plot.ddpcr_plate}}\cr
\code{\link[ddpcr]{custom_thresholds}}
}
