% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rcbv.R
\docType{methods}
\name{rCBV.fast}
\alias{rCBV}
\alias{rCBV.fast}
\alias{rCBV.fast,anlz-method}
\alias{rCBV.fast,array-method}
\alias{rCBV.fast,nifti-method}
\title{Regional Cerebral Blood Volume}
\usage{
rCBV.fast(signal, ...)

\S4method{rCBV.fast}{array}(signal, mask, aif, time, multicore = FALSE,
  verbose = FALSE)

rCBV(Ct, Ca, time, Hf = 1, rho = 1)
}
\arguments{
\item{signal}{is a multidimensional array of signal intensities (or
concentrations).  The last dimension is assumed to be a function of the
acquisition times, while the previous dimenions are assued to be spatial.}

\item{...}{Additional variables defined by the method.}

\item{mask}{is a (logical) multidimensional array that identifies the voxels
to be analyzed.}

\item{aif}{Arterial Input Function.}

\item{time}{is the vector of acquisition times associated with the dynamic
data.}

\item{multicore}{is a logical variable (default = \code{FALSE}) that allows
parallel processing via \pkg{parallel}.}

\item{verbose}{is a logical variable (default = \code{FALSE}) that allows
text-based feedback during execution of the function.}

\item{Ct}{is the time series of contrast agent concentration in tissue.}

\item{Ca}{is the time series of contrast agent concentration in the blood.}

\item{Hf}{is the hematocrit factor.}

\item{rho}{is the density of brain tissue.}
}
\value{
A \code{nifti} object containing the estimates of regional cerebral
blood volume (rCBV).
}
\description{
Quantification of relative cerebral blood volume (rCBV) using the first pass
from a bolus injection of a contrast agent.
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{misc}

