% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-team-membership.R
\name{check_team_membership}
\alias{check_team_membership}
\title{Check team membership}
\usage{
check_team_membership(teams, user, syn)
}
\arguments{
\item{teams}{Team IDs to check membership in}

\item{user}{User to check (e.g. output from syn$getUserProfile())}

\item{syn}{Synapse client object}
}
\value{
A condition object indicating whether the Synapse user is a member of
the given team(s).
}
\description{
Check if a user is a member of any of the given teams.
}
\examples{
\dontrun{
syn <- synapse$Synapse()
syn$login()
user <- syn$getUserProfile("dcctravistest")
check_team_membership(teams = "3396691", user = user, syn = syn)
check_team_membership(
  teams = c("3397398", "3377637"),
  user = user,
  syn = syn
)
}
}
