% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-copy-to.R
\name{copy_to.src_sql}
\alias{copy_to.src_sql}
\title{Copy a local data frame to a DBI backend.}
\usage{
\method{copy_to}{src_sql}(
  dest,
  df,
  name = deparse(substitute(df)),
  overwrite = FALSE,
  types = NULL,
  temporary = TRUE,
  unique_indexes = NULL,
  indexes = NULL,
  analyze = TRUE,
  ...
)
}
\arguments{
\item{dest}{remote data source}

\item{df}{A local data frame, a \code{tbl_sql} from same source, or a \code{tbl_sql}
from another source. If from another source, all data must transition
through R in one pass, so it is only suitable for transferring small
amounts of data.}

\item{name}{name for new remote table.}

\item{overwrite}{If \code{TRUE}, will overwrite an existing table with
name \code{name}. If \code{FALSE}, will throw an error if \code{name} already
exists.}

\item{types}{a character vector giving variable types to use for the columns.
See \url{http://www.sqlite.org/datatype3.html} for available types.}

\item{temporary}{if \code{TRUE}, will create a temporary table that is
local to this connection and will be automatically deleted when the
connection expires}

\item{unique_indexes}{a list of character vectors. Each element of the list
will create a new unique index over the specified column(s). Duplicate rows
will result in failure.}

\item{indexes}{a list of character vectors. Each element of the list
will create a new index.}

\item{analyze}{if \code{TRUE} (the default), will automatically ANALYZE the
new table so that the query optimiser has useful information.}

\item{...}{other parameters passed to methods.}
}
\value{
A \code{\link[=tbl]{tbl()}} object (invisibly).
}
\description{
This \code{\link[=copy_to]{copy_to()}} method works for all DBI sources. It is useful for
copying small amounts of data to a database for examples, experiments,
and joins. By default, it creates temporary tables which are typically
only visible to the current connection to the database.
}
\examples{
library(dplyr)
set.seed(1014)

mtcars$model <- rownames(mtcars)
mtcars2 <- src_memdb() \%>\%
  copy_to(mtcars, indexes = list("model"), overwrite = TRUE)
mtcars2 \%>\% filter(model == "Hornet 4 Drive")

cyl8 <- mtcars2 \%>\% filter(cyl == 8)
cyl8_cached <- copy_to(src_memdb(), cyl8)

# copy_to is called automatically if you set copy = TRUE
# in the join functions
df <- tibble(cyl = c(6, 8))
mtcars2 \%>\% semi_join(df, copy = TRUE)
}
