% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_natpsoho.R
\name{natPosition}
\alias{natPosition}
\title{R6 class that defines DBNs as vectors of natural numbers}
\arguments{
\item{nodes}{a vector with the names of the nodes}

\item{ordering}{a vector with the names of the nodes in t_0}

\item{ordering_raw}{a vector with the names of the nodes without the appended "_t_0"}

\item{max_size}{Maximum number of timeslices of the DBN}

\item{vl}{a natVelocity object}

\item{net}{a dbn object}

\item{n_vars}{the number of variables in t_0}

\item{p}{the parameter of the truncated geometric sampler. If lesser or
equal to 0, a uniform distribution will be used instead.}
}
\value{
A new 'natPosition' object

a dbn object

the ordering of the nodes in t_0

a random position

the number of arcs
}
\description{
Constructor of the 'natPosition' class

Translate the vector into a DBN network

Uses this object private cl and transforms it into a DBN.

Add a velocity to the position

Given a natVelocity object, add it to the current position.

Return the static node ordering

This function takes as input a dbn and return the node ordering of the
variables inside a timeslice. This ordering is needed to understand a
position vector.

Translate a DBN into a position vector

This function takes as input a network from a DBN and transforms the 
structure into a vector of natural numbers if it is a valid DBN. Valid 
DBNs have only inter-timeslice edges and only allow variables in t_0 to 
have parents.

Generates a random position

This function takes as input the number of variables, the maximum size
and the parameter p and returns a random position with arcs 
sampled either from the uniform distribution or from a truncated 
geometric distribution. Much faster than the binary implementation with
lists of lists and random bn generation into translation.

Recount the number of arcs in the cl
}
\details{
A natPosition represents a single HO-DBN structure with a vector. Its function
is to encode the solutions in the PSO framework. Each particle will have a 
position.
}
\section{Fields}{

\describe{
\item{\code{n_arcs}}{Number of arcs in the network}

\item{\code{max_size}}{Maximum number of timeslices of the DBN}

\item{\code{p}}{Parameter of the sampling truncated geometric distribution}

\item{\code{nodes}}{Names of the nodes in the network}
}}

