% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.table.R
\name{as.data.table}
\alias{as.data.table}
\alias{as.data.table.dbi.table}
\title{Coerce to \code{data.table}}
\usage{
\method{as.data.table}{dbi.table}(
  x,
  keep.rownames = FALSE,
  ...,
  n = getOption("dbi_table_max_fetch", 10000L)
)
}
\arguments{
\item{x}{a \code{\link{dbi.table}}.}

\item{keep.rownames}{a logical value. This argument is not used.}

\item{\dots}{additional arguments are ignored.}

\item{n}{an integer value. When nonnegative, the underlying SQL query includes a
'LIMIT \code{n}' clause and \code{n} is also passed to
\code{\link[DBI]{dbFetch}}. When negative, the underlying SQL query does
not include a LIMIT clause and all rows in the result set are returned.}
}
\value{
a \code{dbi.table}.
}
\description{
Execute a \code{\link{dbi.table}}'s underlying SQL query and return the
  result set as a \code{\link[data.table]{data.table}}. By default, the
  result set is limited to 10,000 rows. See Details.
}
\details{
By default, \code{as.data.table} returns up to 10,000 rows (see the
  \code{n} argument). To override this limit, either call
  \code{as.data.table} and provide the \code{n} argument (e.g., \code{n = -1}
  to return the entire result set), or set the option
  \code{dbi_table_max_fetch} to the desired default value of \code{n}.
}
\examples{
  duck <- chinook.duckdb()
  Artist <- dbi.table(duck, DBI::Id("Artist"))

  as.data.table(Artist, n = 7)[]

  \dontshow{DBI::dbDisconnect(duck)}

}
\seealso{
\code{\link[data.table]{as.data.table}} (the generic method in the
  \pkg{data.table} package).
}
