% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_result.R
\name{get_datelife_result}
\alias{get_datelife_result}
\title{Get a patristic matrix of time of lineage divergence data for a given set of taxon names}
\usage{
get_datelife_result(
  input = NULL,
  partial = TRUE,
  cache = "opentree_chronograms",
  update_opentree_chronograms = FALSE,
  ...
)
}
\arguments{
\item{input}{One of the following:
\describe{
\item{A character vector}{With taxon names as a single comma separated
starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or
\code{multiPhylo} object, OR as a newick character string.}
\item{A \code{datelifeQuery} object}{An output from \code{\link[=make_datelife_query]{make_datelife_query()}}.}
}}

\item{partial}{Whether to return or exclude partially matching source chronograms,
i.e, those that match some and not all of taxa given in \code{datelife_query}.
Options are \code{TRUE} or \code{FALSE}. Defaults to \code{TRUE}: return all matching source
chronograms.}

\item{cache}{A character vector of length one, with the name of the data object
to cache. Default to \code{"opentree_chronograms"}, a data object storing Open Tree of
Life's database chronograms and other associated information.}

\item{update_opentree_chronograms}{Whether to update the chronogram database or not.
Defaults to \code{FALSE}.}

\item{...}{
  Arguments passed on to \code{\link[=make_datelife_query]{make_datelife_query}}
  \describe{
    \item{\code{use_tnrs}}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}
    \item{\code{get_spp_from_taxon}}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}
  }}
}
\value{
A \code{datelifeResult} object -- a named list of patristic matrices.
}
\description{
\code{get_datelife_result} takes as input a vector of taxon names, a newick string,
a \code{phylo} object, or a\code{datelifeQuery} object. It searches the chronogram
database specified in \code{cache} for chronograms matching two or more given
taxon names. For each matching chronogram, it extracts time of lineage
divergence data and stores it as a patristic matrix. It then lists all
resulting patristic matrices. Each list element is named with the study
citation of the source chronogram.
}
