% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groves.R
\name{build_grove_matrix}
\alias{build_grove_matrix}
\title{Find the grove for a group of chronograms and build a matrix.}
\usage{
build_grove_matrix(datelife_result, n = 2)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object.}

\item{n}{The degree of taxon name overlap among input chronograms. Defaults
to \code{n = 2}, i.e., at least two overlapping taxon names.}
}
\value{
A matrix. Each cell shows whether n-overlap exists between a pair of inputs.
}
\description{
This function implements theorem 1.1 of Anéet al. (2009) \doi{10.1007/s00026-009-0017-x}
to find a grove for a given group of chronograms.
}
\references{
Ané, C., Eulenstein, O., Piaggio-Talice, R., & Sanderson, M. J. (2009).
"Groves of phylogenetic trees". Annals of Combinatorics, 13(2), 139-167,
\doi{10.1007/s00026-009-0017-x}.
}
