% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pibmunic.R
\encoding{UTF-8}
\name{load_pibmunic}
\alias{load_pibmunic}
\title{PIB MUNICIPAL - Municipal GDP}
\usage{
load_pibmunic(
  dataset = "pibmunic",
  raw_data,
  geo_level,
  time_period,
  language = "eng",
  legal_amazon_only = FALSE
)
}
\arguments{
\item{dataset}{A dataset name ("pibmunic") with Municipal GDP information. You can also use SIDRA codes (See \url{https://sidra.ibge.gov.br/pesquisa/pib-munic/tabelas})}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}

\item{legal_amazon_only}{A \code{boolean} setting the return of Legal Amazon Data (\code{TRUE}) or Country's Data (\code{FALSE}).}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on gross domestic product at current prices, taxes, net of subsidies, on products at current prices and gross value added at current prices, total and by economic activity, and respective shares. Survey is done at Country, state and municipality level and data is available from 2002 to 2018.
}
\examples{
\dontrun{
# download state raw data from 2012 for all country
pibmunic <- load_pibmunic(dataset = 'pibmunic',
                          raw_data = TRUE,
                          geo_level = 'state',
                          time_period = 2012,
                          legal_amazon_only = FALSE)
}
}
