% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dv_backup.R
\name{read_dv_backup}
\alias{read_dv_backup}
\title{Read dv backup}
\usage{
read_dv_backup(destination, as_of)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{as_of}{the valid date at which you'd like to read the dv}
}
\value{
a data frame
}
\description{
Read a version of a versioned dataset into a data frame using just the stored backups
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
create_dv(df, temp_dir, backup_count = 5L)

read_dv_backup(temp_dir, as_of = lubridate::now())

unlink(temp_dir)

}
