% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datacite.R
\name{datacite}
\alias{datacite}
\alias{as_datacite}
\alias{is.datacite}
\alias{is.datacite.datacite}
\title{Create a bibentry object with DataCite metadata fields}
\source{
\href{https://support.datacite.org/docs/schema-mandatory-properties-v43}{DataCite 4.3 Mandatory Properties} and
\href{https://support.datacite.org/docs/schema-optional-properties-v43}{DataCite 4.3 Optional Properties}
}
\usage{
datacite(
  Title,
  Creator,
  Identifier = NULL,
  Publisher = NULL,
  PublicationYear = NULL,
  Subject = subject_create(term = "data sets", subjectScheme =
    "Library of Congress Subject Headings (LCSH)", schemeURI =
    "https://id.loc.gov/authorities/subjects.html", valueURI =
    "http://id.loc.gov/authorities/subjects/sh2018002256"),
  Type = "Dataset",
  Contributor = NULL,
  DateList = ":tba",
  Language = NULL,
  AlternateIdentifier = ":unas",
  RelatedIdentifier = ":unas",
  Format = ":tba",
  Version = "0.1.0",
  Rights = ":tba",
  Description = ":tba",
  Geolocation = ":unas",
  FundingReference = ":unas"
)

as_datacite(x, type = "bibentry", ...)

is.datacite(x)

\method{is.datacite}{datacite}(x)
}
\arguments{
\item{Title}{The name(s) or title(s) by which a resource is known. May be the
title of a dataset or the name of a piece of software.
Similar to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/title/}{dct:title}.\cr}

\item{Creator}{The main researchers involved in producing the data, or the authors of the publication, in
priority order. To supply multiple creators, repeat this property.}

\item{Identifier}{The Identifier is a unique string that identifies a resource. For software, determine
whether the identifier is for a specific version of a piece of software, (per the
\href{https://force11.org/info/software-citation-principles-published-2016/}{Force11 Software Citation Principles},
or for all versions. Similar to \code{dct:title} in \code{\link[=dublincore]{dublincore()}}.}

\item{Publisher}{The name of the entity that holds, archives, publishes prints,
distributes, releases, issues, or produces the resource. This property will be used to
formulate the citation, so consider the prominence of the role.
For software, use Publisher for the code repository. Mandatory in DataCite, and similar to
\code{dct:publisher}. See \code{\link[=publisher]{publisher()}}.}

\item{PublicationYear}{The year when the data was or will be made publicly available in
\code{YYYY} format.See \code{\link[=publication_year]{publication_year()}}.}

\item{Subject}{Recommended for discovery. Subject, keyword, classification code, or key
phrase describing the resource. Similar to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/subject/}{dct:subject}. \cr
Use \code{\link{subject}} to properly add a key phrase from a controlled vocabulary
and create structured Subject objects with \code{\link{subject_create}}.}

\item{Type}{Defaults to \code{Dataset}.
The DataCite resourceType definition refers back to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/type/}{dcm:type}.
The \code{Type$resourceTypeGeneral} is set to  \code{"Dataset"}, while the user can set a more
specific \code{Type$resourceType} value.}

\item{Contributor}{Recommended for discovery. The institution or person responsible for collecting, managing, distributing, or otherwise contributing to the development of the resource.}

\item{DateList}{DataCite 4.4 allows to set multiple dates to a resource, they should
be added as a list. See:
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#8-date}{datacite:Date}.}

\item{Language}{The primary language of the resource. Allowed values are taken from
IETF BCP 47, ISO 639-1 language code. See \code{\link[=language]{language()}}.}

\item{AlternateIdentifier}{An identifier or identifiers other than the primary
Identifier applied to the resource being registered. This may be any
alphanumeric string unique within its domain of issue. It may be used for
local identifiers.
\code{AlternateIdentifier} should be used for another
identifier of the same instance (same location, same file).
Defaults to \code{":unas"} for unassigned values.}

\item{RelatedIdentifier}{Recommended for discovery.
Defaults to \code{":unas"} for unassigned values.
Similar to
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/relation/}{dct:relation}.}

\item{Format}{Technical format of the resource. Use file extension or MIME
type where possible, e.g., PDF, XML, MPG or application/pdf, text/xml, video/mpeg.
Similar to \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/format/}{dct:format}.}

\item{Version}{Free text. Suggested practice: track major_version.minor_version.
Defaults to \code{"0.1.0"}.
See \code{\link{version}}.}

\item{Rights}{Any rights information for this resource. The property may be
repeated to record complex rights characteristics, but this is not yet supported.
Free text. See \code{\link{rights}}.
Defaults to \code{":tba"}.}

\item{Description}{Recommended for discovery. All additional information that does not
fit in any of the other categories. It may be used for technical information—a free text.
Defaults to \code{":tba"}.
Similar to \href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/elements11/description/}{dct:description}.}

\item{Geolocation}{Recommended for discovery. Spatial region or named place where the data was gathered
or about which the data is focused. See \code{\link[=geolocation]{geolocation()}}.}

\item{FundingReference}{Information about financial support (funding) for the resource
being registered.
Defaults to \code{":unas"} for unassigned values. Complex types with subproperties
are not yet implemented.}

\item{x}{An object that is tested if it has a class "datacite".}

\item{type}{A DataCite 4.4  metadata can be returned as a \code{type="list"},
a \code{type="dataset_df"}, or a \code{type="bibentry"} (default).}

\item{...}{Optional parameters to add to a \code{datacite} object.
\code{author=person("Jane", "Doe")} adds an author to the citation
object if \code{type="dataset"}.
as_datacite(iris_dataset, type="list")}
}
\value{
\code{datacite()} creates a \code{utils::\link[utils]{bibentry}} object
extended with standard Dublin Core bibliographical metadata, \code{as_datacite()}
retrieves the contents of this bibentry object of a dataset_df from its
attributes, and returns the contents as list, dataset_df, or bibentry object.

\code{as_datacite(x, type)} returns the DataCite bibliographical metadata
of x either as a list, a bibentry object, or a dataset_df object.

\code{is.datacite(x)} returns a logical values (if the object \code{x}
is of class \code{datacite}).
}
\description{
Add metadata conforming
the \href{https://schema.datacite.org/}{DataCite Metadata Schema}.
}
\details{
DataCite is a leading global non-profit organisation that provides
persistent identifiers (DOIs) for research data and other research outputs.
Organisations within the research community join DataCite as members to be
able to assign DOIs to all their research outputs. This way, their outputs
become discoverable, and associated metadata is made available to the community.

The \code{ResourceType} property will be by definition "Dataset".
The \code{Size} attribute (e.g. bytes, pages, inches, etc.) will automatically added to
the dataset.
}
\examples{
datacite(
   Title = "Iris Dataset",
   Creator = person(family = "Anderson", given = "Edgar", role = "aut"),
   Publisher = "American Iris Society",
   PublicationYear = 1935,
   Geolocation = "US",
   Language = "en")

as_datacite(iris_dataset)
}
\seealso{
Other bibentry functions: 
\code{\link{dublincore}()},
\code{\link{get_bibentry}()}
}
\concept{bibentry functions}
