% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xsd_convert.R
\name{xsd_convert}
\alias{xsd_convert}
\alias{xsd_convert.data.frame}
\alias{xsd_convert.dataset}
\alias{xsd_convert.tibble}
\alias{xsd_convert.character}
\alias{xsd_convert.numeric}
\alias{xsd_convert.integer}
\alias{xsd_convert.boolean}
\alias{xsd_convert.factor}
\alias{xsd_convert.POSIXct}
\alias{xsd_convert.Date}
\title{Convert to XML Schema Definition (XSD) types}
\usage{
xsd_convert(x, idcol, ...)

\method{xsd_convert}{data.frame}(x, idcol = NULL, ...)

\method{xsd_convert}{dataset}(x, idcol = NULL, ...)

\method{xsd_convert}{tibble}(x, idcol = NULL, ...)

\method{xsd_convert}{character}(x, idcol = NULL, ...)

\method{xsd_convert}{numeric}(x, idcol = NULL, ...)

\method{xsd_convert}{integer}(x, idcol = NULL, ...)

\method{xsd_convert}{boolean}(x, idcol = NULL, ...)

\method{xsd_convert}{factor}(x, idcol = NULL, ...)

\method{xsd_convert}{POSIXct}(x, idcol = NULL, ...)

\method{xsd_convert}{Date}(x, idcol = NULL, ...)
}
\arguments{
\item{x}{An R object that contains the data of the dataset (a data.frame or
inherited from \code{\link[base:data.frame]{data.frame}}), for example,
\code{\link[tibble:tibble]{tibble::tibble()}}, \code{\link[tsibble:tsibble]{tsibble::tsibble()}}, \code{\link[data.table:data.table]{data.table::data.table()}}.}

\item{idcol}{The name or position of the column that contains the row
(observation) identifiers. If \code{NULL}, it will make a new \code{idcol}
from \code{\link[=row.names]{row.names()}}.}

\item{...}{Further optional parameters for generic method.}
}
\description{
Convert the numeric, boolean and Date/time columns of a dataset
\code{xs:decimal}, \code{xsLboolean}, \code{xs:date} and \code{xs:dateTime}.
}
\examples{

# Convert data.frame to XML Schema Definition
xsd_convert(head(iris))

# Convert dataset to XML Schema Definition
xsd_convert(head(iris_dataset))
}
\seealso{
\code{\link[=dataset]{dataset()}}
}
