% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-iris_dataset.R
\docType{data}
\name{iris_dataset}
\alias{iris_dataset}
\title{Edgar Anderson's Iris Data}
\format{
iris is a data frame with 150 cases (rows) and 5 variables (columns) named
Sepal.Length, Sepal.Width, Petal.Length, Petal.Width, and Species.
}
\source{
Fisher, R. A. (1936) The use of multiple measurements in taxonomic problems.
Annals of Eugenics, \strong{7}, Part II, p179–188.

The data were collected by Anderson, Edgar (1935).
The irises of the Gaspe Peninsula,
Bulletin of the American Iris Society, \strong{59},
\href{https://www.biodiversitylibrary.org/item/270486#page/344/mode/1up}{2–5}.
}
\usage{
iris_dataset
}
\description{
This famous (Fisher's or Anderson's) iris data set gives the measurements in
centimetres of the variables sepal length and width and petal length and
width, respectively, for 50 flowers from each of 3 species of iris.
The species are \emph{Iris setosa}, \emph{versicolor}, and \emph{virginica}.
This is a replication of \code{datasets::\link[datasets:iris]{iris}} as
\emph{dataset} s3 class.
}
\details{
See \code{datasets::\link[datasets:iris]{iris}} for details.
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language.
Wadsworth & Brooks/Cole.
}
\keyword{datasets}
