% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{GetRatingTable}
\alias{GetRatingTable}
\title{Retrieve a single rating table.}
\usage{
GetRatingTable(project, ratingTableId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{ratingTableId}{character. The ID of the rating table.}
}
\value{
An S3 object of class 'dataRobotRatingTable' summarizing all
  available information about the rating table.
}
\description{
Retrieve a single rating table.
}
\examples{
\dontrun{
 projectId <- "5984b4d7100d2b31c1166529"
 ratingTableId <- "5984b4d7100d2b31c1166529"
 GetRatingTable(projectId, ratingTableId)
}
}
