% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPredictions.R
\name{GetPredictions}
\alias{GetPredictions}
\title{Retrieve model predictions from predictJobId}
\usage{
GetPredictions(project, predictJobId, type = "response",
  classPrefix = "class_", maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictJobId}{integer. Id identifying the prediction job
created by the call to \code{RequestPredictionsForDataset}.}

\item{type}{character. String specifying the type of response for
binary classifiers; see Details.}

\item{classPrefix}{character. For multiclass projects returning prediction probabilities,
this prefix is prepended to each class in the header of the dataframe. Defaults to
"class_".}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the prediction job
to complete.}
}
\value{
Vector of predictions, depending on the modeling task
("Binary", "Multiclass", or "Regression") and the value of the type parameter;
see Details.
}
\description{
This function is called with a project descriptor and an
integer predictJobId, obtained from an earlier call to
\code{RequestPredictionsForDataset}. It returns the predictions generated
for the model and data specified in this prior function
call.
}
\details{
The contents of the return vector depends on both the modeling
task - binary classification, multiclass classification, or regression
- and the value of the type parameter.  For regression tasks, the type
parameter is ignored and a vector of numerical predictions of the response
variable is returned.

For binary classification tasks, either
a vector of predicted responses is returned if type has the
value "response" (the default), or a vector of probabilities
for the positive class is returned, if type is "probability".

For multiclass classification tasks, "response" will return the predicted
class and "probability" will return the probability of each class.

This function will error if the requested job has errored, or
if it isn't complete within maxWait seconds.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetPredictJobs(project)
  job <- initialJobs[[1]]
  predictJobId <- job$predictJobId
  GetPredictions(projectId, predictJobId)
}
}
