% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_dist_selection.R
\name{util_dist_selection}
\alias{util_dist_selection}
\title{Utility function to characterize study variables}
\usage{
util_dist_selection(study_data, val_lab = lifecycle::deprecated())
}
\arguments{
\item{study_data}{study data, pre-processed with \code{prep_prepare_dataframes}
to replace missing value codes by \code{NA}}

\item{val_lab}{deprecated}
}
\value{
data frame with one row for each variable in the study data and the
following columns:
\code{Variables} contains the names of the variables
\code{IsInteger} contains a check whether the variable contains integer values
only (variables coded as factor will be converted to integers)
\code{IsMultCat} contains a check for variables with integer or string values
whether there are more than two categories
\code{NCategory} contains the number of distinct values for variables with
values coded as integers or strings (excluding \code{NA} and
empty entries)
\code{AnyNegative} contains a check whether the variable contains any negative
values
\code{NDistinct} contains the number of distinct values
\code{PropZeroes} reports the proportion of zeroes
}
\description{
This function summarizes some properties of measurement variables.
}
\seealso{
Other metadata_management: 
\code{\link{util_find_free_missing_code}()},
\code{\link{util_find_var_by_meta}()},
\code{\link{util_get_var_att_names_of_level}()},
\code{\link{util_get_vars_in_segment}()},
\code{\link{util_looks_like_missing}()},
\code{\link{util_no_value_labels}()},
\code{\link{util_validate_known_meta}()},
\code{\link{util_validate_missing_lists}()}
}
\concept{metadata_management}
\concept{process}
\keyword{internal}
