% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_evaluate_calls.R
\name{util_evaluate_calls}
\alias{util_evaluate_calls}
\title{Generate a full DQ report, v2}
\usage{
util_evaluate_calls(
  all_calls,
  study_data,
  meta_data,
  label_col,
  meta_data_segment,
  meta_data_dataframe,
  meta_data_cross_item,
  resp_vars,
  filter_result_slots,
  cores,
  debug_parallel
)
}
\arguments{
\item{all_calls}{\link{list} a list of calls}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional: Data frame level
metadata}

\item{meta_data_cross_item}{\link{data.frame} -- optional: cross-item level
metadata}

\item{resp_vars}{\link{variable list} the name of the measurement variables
for the report.}

\item{filter_result_slots}{\link{character} regular expressions, only
if an indicator function's
result's name
matches one of these, it'll
be used for the report. If
of length zero, no filtering
is performed.}

\item{cores}{\link{integer} number of cpu cores to use or a named list with
arguments for \link[parallelMap:parallelStart]{parallelMap::parallelStart} or NULL,
if parallel has already been started by the caller.}

\item{debug_parallel}{\link{logical} print blocks currently evaluated in parallel}
}
\value{
a \link{dataquieR_resultset2}. Can be printed creating a RMarkdown-report.
}
\description{
Generate a full DQ report, v2
}
