% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_unexp_records_segment.R
\name{int_unexp_records_segment}
\alias{int_unexp_records_segment}
\title{Check for unexpected data record count within segments}
\usage{
int_unexp_records_segment(
  study_segment,
  data_record_count,
  study_data,
  meta_data
)
}
\arguments{
\item{study_segment}{\link{character} a character vector indicating the name of each study data frame, mandatory.}

\item{data_record_count}{\link{integer}  an integer vector with the number of expected data records, mandatory.}

\item{study_data}{\link{data.frame} the data frame that contains the measurements, mandatory.}

\item{meta_data}{\link{data.frame} the data frame that contains metadata attributes of the study data, mandatory.}
}
\value{
a \link{list} with
\itemize{
\item \code{SegmentData}: data frame with the results of the quality check for unexpected data elements
\item \code{SegmentTable}: data frame with selected unexpected data elements check results, used for the data quality report.
}
}
\description{
This function contrasts the expected record number in each study segment in
the metadata with the actual record number in each segment data frame.
}
\details{
The current implementation does not take into account jump or missing codes, the function is rather based on checking whether NAs are present in the study data
}
\examples{
\dontrun{
study_data <- readRDS(system.file("extdata", "ship.RDS", package = "dataquieR"))
meta_data <- readRDS(system.file("extdata", "ship_meta.RDS", package = "dataquieR"))

int_unexp_records_segment(
  study_segment = c("PART_STUDY", "PART_INTERVIEW"),
  data_record_count = c(3000, 1100),
  study_data = study_data,
  meta_data = meta_data
)
}

}
