% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\docType{methods}
\name{validate}
\alias{validate}
\alias{validate,SystemMetadata-method}
\title{Validate a SystemMetadata object.}
\usage{
validate(x, ...)

\S4method{validate}{SystemMetadata}(x, ...)
}
\arguments{
\item{x}{the instance to be validated}

\item{...}{(Additional parameters)}
}
\value{
logical, \code{TRUE} if the SystemMetadata object is valid, else a list of strings detailing errors
}
\description{
Validate a system metadata object, ensuring that required fields are present and of the right type.
}
\examples{
library(XML)
doc <- xmlParseDoc(system.file("testfiles/sysmeta.xml", package="datapack"), asText=FALSE)
sysmeta <- new("SystemMetadata")
sysmeta <- parseSystemMetadata(sysmeta, xmlRoot(doc))
valid <- validate(sysmeta)
}
\seealso{
\code{\link{SystemMetadata-class}}
}

