/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.util.CharArrayBuffer;

public final class MimeUtil {
    private static final Log log = LogFactory.getLog((Class)MimeUtil.class);
    public static final String ENC_QUOTED_PRINTABLE = "quoted-printable";
    public static final String ENC_BINARY = "binary";
    public static final String ENC_BASE64 = "base64";
    public static final String ENC_8BIT = "8bit";
    public static final String ENC_7BIT = "7bit";
    public static final String MIME_HEADER_MIME_VERSION = "mime-version";
    public static final String MIME_HEADER_CONTENT_ID = "content-id";
    public static final String MIME_HEADER_CONTENT_DESCRIPTION = "content-description";
    public static final String MIME_HEADER_CONTENT_DISPOSITION = "content-disposition";
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_MODIFICATION_DATE = "modification-date";
    public static final String PARAM_CREATION_DATE = "creation-date";
    public static final String PARAM_READ_DATE = "read-date";
    public static final String PARAM_SIZE = "size";
    public static final String MIME_HEADER_LANGAUGE = "content-language";
    public static final String MIME_HEADER_LOCATION = "content-location";
    public static final String MIME_HEADER_MD5 = "content-md5";
    private static final Random random = new Random();
    private static int counter = 0;

    private MimeUtil() {
    }

    public static boolean isSameMimeType(String pType1, String pType2) {
        return pType1 != null && pType2 != null && pType1.equalsIgnoreCase(pType2);
    }

    public static boolean isMessage(String pMimeType) {
        return pMimeType != null && pMimeType.equalsIgnoreCase("message/rfc822");
    }

    public static boolean isMultipart(String pMimeType) {
        return pMimeType != null && pMimeType.toLowerCase().startsWith("multipart/");
    }

    public static boolean isBase64Encoding(String pTransferEncoding) {
        return ENC_BASE64.equalsIgnoreCase(pTransferEncoding);
    }

    public static boolean isQuotedPrintableEncoded(String pTransferEncoding) {
        return ENC_QUOTED_PRINTABLE.equals(pTransferEncoding);
    }

    public static Map getHeaderParams(String pValue) {
        String rest;
        String main;
        pValue = pValue.trim();
        CharArrayBuffer sb = new CharArrayBuffer(128);
        for (int i = 0; i < pValue.length(); ++i) {
            char c = pValue.charAt(i);
            if (c == '\r' || c == '\n') continue;
            sb.append(c);
        }
        pValue = sb.toString();
        HashMap<String, String> result = new HashMap<String, String>();
        if (pValue.indexOf(";") == -1) {
            main = pValue;
            rest = null;
        } else {
            main = pValue.substring(0, pValue.indexOf(";"));
            rest = pValue.substring(main.length() + 1);
        }
        result.put("", main);
        if (rest != null) {
            char[] chars = rest.toCharArray();
            CharArrayBuffer paramName = new CharArrayBuffer(64);
            CharArrayBuffer paramValue = new CharArrayBuffer(64);
            boolean READY_FOR_NAME = false;
            boolean IN_NAME = true;
            int READY_FOR_VALUE = 2;
            int IN_VALUE = 3;
            int IN_QUOTED_VALUE = 4;
            int VALUE_DONE = 5;
            int ERROR = 99;
            int state = 0;
            boolean escaped = false;
            block25: for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                switch (state) {
                    case 99: {
                        if (c != ';') continue block25;
                        state = 0;
                        continue block25;
                    }
                    case 0: {
                        if (c == '=') {
                            log.error((Object)"Expected header param name, got '='");
                            state = 99;
                            continue block25;
                        }
                        paramName = new CharArrayBuffer(64);
                        paramValue = new CharArrayBuffer(64);
                        state = 1;
                    }
                    case 1: {
                        if (c == '=') {
                            if (paramName.length() == 0) {
                                state = 99;
                                continue block25;
                            }
                            state = 2;
                            continue block25;
                        }
                        paramName.append(c);
                        continue block25;
                    }
                    case 2: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case '\"': {
                                state = 4;
                                break;
                            }
                            default: {
                                state = 3;
                                fallThrough = true;
                            }
                        }
                        if (!fallThrough) continue block25;
                    }
                    case 3: {
                        boolean fallThrough = false;
                        switch (c) {
                            case '\t': 
                            case ' ': 
                            case ';': {
                                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
                                state = 5;
                                fallThrough = true;
                                break;
                            }
                            default: {
                                paramValue.append(c);
                            }
                        }
                        if (!fallThrough) continue block25;
                    }
                    case 5: {
                        switch (c) {
                            case ';': {
                                state = 0;
                                continue block25;
                            }
                            case '\t': 
                            case ' ': {
                                continue block25;
                            }
                        }
                        state = 99;
                        continue block25;
                    }
                    case 4: {
                        switch (c) {
                            case '\"': {
                                if (!escaped) {
                                    result.put(paramName.toString().trim().toLowerCase(), paramValue.toString());
                                    state = 5;
                                    continue block25;
                                }
                                escaped = false;
                                paramValue.append(c);
                                continue block25;
                            }
                            case '\\': {
                                if (escaped) {
                                    paramValue.append('\\');
                                }
                                escaped = !escaped;
                                continue block25;
                            }
                        }
                        if (escaped) {
                            paramValue.append('\\');
                        }
                        escaped = false;
                        paramValue.append(c);
                    }
                }
            }
            if (state == 3) {
                result.put(paramName.toString().trim().toLowerCase(), paramValue.toString().trim());
            }
        }
        return result;
    }

    public static String createUniqueBoundary() {
        StringBuffer sb = new StringBuffer();
        sb.append("-=Part.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append("=-");
        return sb.toString();
    }

    public static String createUniqueMessageId(String hostName) {
        StringBuffer sb = new StringBuffer("<Mime4j.");
        sb.append(Integer.toHexString(MimeUtil.nextCounterValue()));
        sb.append('.');
        sb.append(Long.toHexString(random.nextLong()));
        sb.append('.');
        sb.append(Long.toHexString(System.currentTimeMillis()));
        if (hostName != null) {
            sb.append('@');
            sb.append(hostName);
        }
        sb.append('>');
        return sb.toString();
    }

    private static synchronized int nextCounterValue() {
        return counter++;
    }
}

