/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingVector;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngineI;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEClauseFilter;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEConflictSet;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETENode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEQueue;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETERuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETESourceNode;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETETerminal;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RETEEngine
implements FRuleEngineI {
    protected ForwardRuleInfGraphI infGraph;
    protected List rules;
    protected OneToManyMap clauseIndex;
    protected List addsPending = new ArrayList();
    protected List deletesPending = new ArrayList();
    protected RETEConflictSet conflictSet;
    protected HashSet predicatesUsed;
    protected boolean wildcardRule;
    protected boolean recordDerivations;
    long nRulesFired = 0L;
    boolean processedAxioms = false;
    boolean isMonotonic = true;
    protected static Log logger = LogFactory.getLog((Class)FRuleEngine.class);

    public RETEEngine(ForwardRuleInfGraphI parent, List rules) {
        this.infGraph = parent;
        this.rules = rules;
        this.isMonotonic = true;
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (r.isMonotonic()) continue;
            this.isMonotonic = false;
            break;
        }
    }

    public RETEEngine(ForwardRuleInfGraphI parent) {
        this.infGraph = parent;
    }

    public void init(boolean ignoreBrules, Finder inserts) {
        this.compile(this.rules, ignoreBrules);
        this.findAndProcessAxioms();
        this.fastInit(inserts);
    }

    public void fastInit(Finder inserts) {
        this.conflictSet = new RETEConflictSet(new RETERuleContext(this.infGraph, this), this.isMonotonic);
        this.findAndProcessActions();
        if (this.infGraph.getRawGraph() != null) {
            if (this.wildcardRule) {
                ExtendedIterator i = inserts.find(new TriplePattern(null, null, null));
                while (i.hasNext()) {
                    this.addTriple((Triple)i.next(), false);
                }
            } else {
                Iterator p = this.predicatesUsed.iterator();
                while (p.hasNext()) {
                    Node predicate = (Node)p.next();
                    ExtendedIterator i = inserts.find(new TriplePattern(null, predicate, null));
                    while (i.hasNext()) {
                        Triple t = (Triple)i.next();
                        this.addTriple(t, false);
                    }
                }
            }
        }
        this.runAll();
    }

    public synchronized void add(Triple t) {
        this.addTriple(t, false);
        this.runAll();
    }

    public synchronized boolean delete(Triple t) {
        this.deleteTriple(t, false);
        this.runAll();
        return true;
    }

    public long getNRulesFired() {
        return this.nRulesFired;
    }

    public boolean shouldTrace() {
        return true;
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    public Object getRuleStore() {
        return new RuleStore(this.clauseIndex, this.predicatesUsed, this.wildcardRule, this.isMonotonic);
    }

    public void setRuleStore(Object ruleStore) {
        RuleStore rs = (RuleStore)ruleStore;
        this.predicatesUsed = rs.predicatesUsed;
        this.wildcardRule = rs.wildcardRule;
        this.isMonotonic = rs.isMonotonic;
        RETERuleContext context = new RETERuleContext(this.infGraph, this);
        HashMap netCopy = new HashMap();
        this.clauseIndex = new OneToManyMap();
        Iterator i = rs.clauseIndex.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.clauseIndex.put(entry.getKey(), ((RETENode)entry.getValue()).clone(netCopy, context));
        }
    }

    public void requestRuleFiring(Rule rule, BindingEnvironment env, boolean isAdd) {
        this.conflictSet.add(rule, env, isAdd);
    }

    public void compile(List rules, boolean ignoreBrules) {
        this.clauseIndex = new OneToManyMap();
        this.predicatesUsed = new HashSet();
        this.wildcardRule = false;
        Iterator it = rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            if (ignoreBrules && rule.isBackward()) continue;
            int numVars = rule.getNumVars();
            boolean[] seenVar = new boolean[numVars];
            RETESourceNode prior = null;
            for (int i = 0; i < rule.bodyLength(); ++i) {
                ClauseEntry clause = rule.getBodyElement(i);
                if (!(clause instanceof TriplePattern)) continue;
                ArrayList clauseVars = new ArrayList(numVars);
                RETEClauseFilter clauseNode = RETEClauseFilter.compile((TriplePattern)clause, numVars, clauseVars);
                Node predicate = ((TriplePattern)clause).getPredicate();
                if (predicate.isVariable()) {
                    this.clauseIndex.put(Node.ANY, clauseNode);
                    this.wildcardRule = true;
                } else {
                    this.clauseIndex.put(predicate, clauseNode);
                    if (!this.wildcardRule) {
                        this.predicatesUsed.add(predicate);
                    }
                }
                ArrayList<Byte> matchIndices = new ArrayList<Byte>(numVars);
                Iterator iv = clauseVars.iterator();
                while (iv.hasNext()) {
                    int varIndex = ((Node_RuleVariable)iv.next()).getIndex();
                    if (seenVar[varIndex]) {
                        matchIndices.add(new Byte((byte)varIndex));
                    }
                    seenVar[varIndex] = true;
                }
                if (prior == null) {
                    prior = clauseNode;
                    continue;
                }
                RETEQueue leftQ = new RETEQueue(matchIndices);
                RETEQueue rightQ = new RETEQueue(matchIndices);
                leftQ.setSibling(rightQ);
                rightQ.setSibling(leftQ);
                clauseNode.setContinuation(rightQ);
                prior.setContinuation(leftQ);
                prior = leftQ;
            }
            if (prior == null) continue;
            RETETerminal term = this.createTerminal(rule);
            prior.setContinuation(term);
        }
        if (this.wildcardRule) {
            this.predicatesUsed = null;
        }
    }

    protected RETETerminal createTerminal(Rule rule) {
        return new RETETerminal(rule, this, this.infGraph);
    }

    public synchronized void addTriple(Triple triple, boolean deduction) {
        if (this.infGraph.shouldTrace()) {
            logger.debug((Object)("Add triple: " + PrintUtil.print(triple)));
        }
        if (this.deletesPending.size() > 0) {
            this.deletesPending.remove(triple);
        }
        this.addsPending.add(triple);
        if (deduction) {
            this.infGraph.addDeduction(triple);
        }
    }

    public synchronized void deleteTriple(Triple triple, boolean deduction) {
        this.addsPending.remove(triple);
        this.deletesPending.add(triple);
        if (deduction) {
            this.infGraph.getCurrentDeductionsGraph().delete(triple);
            Graph raw = this.infGraph.getRawGraph();
            if (raw.contains(triple)) {
                this.deletesPending.remove(triple);
            }
        }
    }

    protected void incRuleCount() {
        ++this.nRulesFired;
    }

    protected synchronized Triple nextAddTriple() {
        int size = this.addsPending.size();
        if (size > 0) {
            return (Triple)this.addsPending.remove(size - 1);
        }
        return null;
    }

    protected synchronized Triple nextDeleteTriple() {
        int size = this.deletesPending.size();
        if (size > 0) {
            return (Triple)this.deletesPending.remove(size - 1);
        }
        return null;
    }

    public void runAll() {
        while (true) {
            boolean isAdd = false;
            Triple next = this.nextDeleteTriple();
            if (next == null) {
                next = this.nextAddTriple();
                isAdd = true;
            }
            if (next == null) {
                if (this.conflictSet.isEmpty()) {
                    return;
                }
                this.conflictSet.fireOne();
                continue;
            }
            this.inject(next, isAdd);
        }
    }

    private void inject(Triple t, boolean isAdd) {
        if (this.infGraph.shouldTrace()) {
            logger.debug((Object)((isAdd ? "Inserting" : "Deleting") + " triple: " + PrintUtil.print(t)));
        }
        Iterator i1 = this.clauseIndex.getAll(t.getPredicate());
        Iterator i2 = this.clauseIndex.getAll(Node.ANY);
        ConcatenatedIterator i = new ConcatenatedIterator(i1, i2);
        while (i.hasNext()) {
            RETEClauseFilter cf = (RETEClauseFilter)i.next();
            cf.fire(t, isAdd);
        }
    }

    public void testTripleInsert(Triple t) {
        Iterator i1 = this.clauseIndex.getAll(t.getPredicate());
        Iterator i2 = this.clauseIndex.getAll(Node.ANY);
        ConcatenatedIterator i = new ConcatenatedIterator(i1, i2);
        while (i.hasNext()) {
            RETEClauseFilter cf = (RETEClauseFilter)i.next();
            cf.fire(t, true);
        }
    }

    protected void findAndProcessAxioms() {
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (!r.isAxiom()) continue;
            RETERuleContext context = new RETERuleContext(this.infGraph, this);
            context.setEnv(new BindingVector(new Node[r.getNumVars()]));
            context.setRule(r);
            if (!context.shouldFire(true)) continue;
            RETEConflictSet.execute(context, true);
        }
        this.processedAxioms = true;
    }

    protected void findAndProcessActions() {
        RETERuleContext tempContext = new RETERuleContext(this.infGraph, this);
        Iterator i = this.rules.iterator();
        while (i.hasNext()) {
            Rule r = (Rule)i.next();
            if (r.bodyLength() != 0) continue;
            for (int j = 0; j < r.headLength(); ++j) {
                ClauseEntry head = r.getHeadElement(j);
                if (!(head instanceof Functor)) continue;
                Functor f = (Functor)head;
                Builtin imp = f.getImplementor();
                if (imp != null) {
                    tempContext.setRule(r);
                    tempContext.setEnv(new BindingVector(r.getNumVars()));
                    imp.headAction(f.getArgs(), f.getArgLength(), tempContext);
                    continue;
                }
                throw new ReasonerException("Invoking undefined Functor " + f.getName() + " in " + r.toShortString());
            }
        }
    }

    public static class RuleStore {
        protected OneToManyMap clauseIndex;
        protected HashSet predicatesUsed;
        protected boolean wildcardRule;
        protected boolean isMonotonic = true;

        RuleStore(OneToManyMap clauseIndex, HashSet predicatesUsed, boolean wildcardRule, boolean isMonotonic) {
            this.clauseIndex = clauseIndex;
            this.predicatesUsed = predicatesUsed;
            this.wildcardRule = wildcardRule;
            this.isMonotonic = isMonotonic;
        }
    }

    protected static class ClausePointer {
        protected Rule rule;
        protected int index;

        ClausePointer(Rule rule, int index) {
            this.rule = rule;
            this.index = index;
        }

        TriplePattern getClause() {
            return (TriplePattern)this.rule.getBodyElement(this.index);
        }
    }
}

