/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler;

import com.hp.hpl.jena.assembler.AssemblerHelp;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ModelExpansion {
    private static final Property ANY = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public static Model withSchema(Model model, Model schema) {
        Model result = ModelFactory.createDefaultModel().add(model);
        ModelExpansion.addSubclassesFrom(result, schema);
        ModelExpansion.addSubClassClosure(result);
        ModelExpansion.addDomainTypes(result, schema);
        ModelExpansion.addRangeTypes(result, schema);
        ModelExpansion.addIntersections(result, schema);
        ModelExpansion.addSupertypes(result);
        return result;
    }

    protected static void addSubclassesFrom(Model result, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.subClassOf, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            if (!s.getSubject().isURIResource() || !s.getObject().isURIResource()) continue;
            result.add(s);
        }
    }

    public static void addSubClassClosure(Model m) {
        Set roots = ModelExpansion.selectRootClasses(m, ModelExpansion.findClassesBySubClassOf(m));
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            ModelExpansion.addSuperClasses(m, (Resource)it.next());
        }
    }

    private static void addSuperClasses(Model m, Resource type) {
        ModelExpansion.addSuperClasses(m, new LinkedSeq(type));
    }

    private static void addSuperClasses(Model m, LinkedSeq parents) {
        Model toAdd = ModelFactory.createDefaultModel();
        ModelExpansion.addSuperClasses(m, parents, toAdd);
        m.add(toAdd);
    }

    private static void addSuperClasses(Model m, LinkedSeq parents, Model toAdd) {
        Resource type = parents.item;
        StmtIterator it = m.listStatements(null, RDFS.subClassOf, type);
        while (it.hasNext()) {
            Resource t = it.nextStatement().getSubject();
            LinkedSeq scan = parents.rest;
            while (scan != null) {
                toAdd.add(t, RDFS.subClassOf, scan.item);
                scan = scan.rest;
            }
            ModelExpansion.addSuperClasses(m, parents.push(t), toAdd);
        }
    }

    private static Set selectRootClasses(Model m, Set classes) {
        HashSet<Resource> roots = new HashSet<Resource>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Resource type = (Resource)it.next();
            if (m.contains(type, RDFS.subClassOf, (RDFNode)null)) continue;
            roots.add(type);
        }
        return roots;
    }

    private static Set findClassesBySubClassOf(Model m) {
        HashSet classes = new HashSet();
        StmtIterator it = m.listStatements(null, RDFS.subClassOf, (RDFNode)null);
        while (it.hasNext()) {
            ModelExpansion.addClasses(classes, it.nextStatement());
        }
        return classes;
    }

    private static void addClasses(Set classes, Statement xSubClassOfY) {
        classes.add(xSubClassOfY.getSubject());
        classes.add(xSubClassOfY.getObject());
    }

    protected static void addDomainTypes(Model result, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.domain, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Property property = (Property)s.getSubject().as(class$com$hp$hpl$jena$rdf$model$Property == null ? ModelExpansion.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property);
            RDFNode type = s.getObject();
            StmtIterator x = result.listStatements((Resource)ANY, property, ANY);
            while (x.hasNext()) {
                Statement t = x.nextStatement();
                result.add(t.getSubject(), RDF.type, type);
            }
        }
    }

    protected static void addRangeTypes(Model result, Model schema) {
        Model toAdd = ModelFactory.createDefaultModel();
        StmtIterator it = schema.listStatements((Resource)ANY, RDFS.range, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            RDFNode type = s.getObject();
            Property property = (Property)s.getSubject().as(class$com$hp$hpl$jena$rdf$model$Property == null ? ModelExpansion.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property);
            StmtIterator x = result.listStatements((Resource)ANY, property, ANY);
            while (x.hasNext()) {
                RDFNode ob = x.nextStatement().getObject();
                if (!ob.isResource()) continue;
                toAdd.add((Resource)ob, RDF.type, type);
            }
        }
        result.add(toAdd);
    }

    protected static void addSupertypes(Model result) {
        Model temp = ModelFactory.createDefaultModel();
        StmtIterator it = result.listStatements((Resource)ANY, RDF.type, ANY);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource c = AssemblerHelp.getResource(s);
            StmtIterator subclasses = result.listStatements(c, RDFS.subClassOf, ANY);
            while (subclasses.hasNext()) {
                RDFNode type = subclasses.nextStatement().getObject();
                temp.add(s.getSubject(), RDF.type, type);
            }
        }
        result.add(temp);
    }

    private static void addIntersections(Model result, Model schema) {
        StmtIterator it = schema.listStatements((Resource)ANY, OWL.intersectionOf, ANY);
        while (it.hasNext()) {
            ModelExpansion.addIntersections(result, schema, it.nextStatement());
        }
    }

    private static void addIntersections(Model result, Model schema, Statement s) {
        Resource type = s.getSubject();
        List types = ModelExpansion.asJavaList(AssemblerHelp.getResource(s));
        Set candidates = ModelExpansion.subjectSet(result, ANY, RDF.type, (Resource)types.get(0));
        for (int i = 1; i < types.size(); ++i) {
            ModelExpansion.removeElementsWithoutType(candidates, (Resource)types.get(i));
        }
        ModelExpansion.addTypeToAll(type, candidates);
    }

    private static void addTypeToAll(Resource type, Set candidates) {
        List types = ModelExpansion.equivalentTypes(type);
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            for (int i = 0; i < types.size(); ++i) {
                resource.addProperty(RDF.type, (Resource)types.get(i));
            }
        }
    }

    private static List equivalentTypes(Resource type) {
        ArrayList<Resource> types = new ArrayList<Resource>();
        types.add(type);
        StmtIterator it = type.getModel().listStatements((Resource)ANY, OWL.equivalentClass, type);
        while (it.hasNext()) {
            types.add(it.nextStatement().getSubject());
        }
        return types;
    }

    private static void removeElementsWithoutType(Set candidates, Resource type) {
        Iterator it = candidates.iterator();
        while (it.hasNext()) {
            Resource candidate = (Resource)it.next();
            if (candidate.hasProperty(RDF.type, type)) continue;
            it.remove();
        }
    }

    private static Set subjectSet(Model result, Resource S, Property P, RDFNode O) {
        return IteratorCollection.iteratorToSet(result.listStatements(S, P, O).mapWith(Statement.Util.getSubject));
    }

    private static List asJavaList(Resource resource) {
        return ((RDFList)resource.as(RDFList.class)).asJavaList();
    }

    protected static class LinkedSeq {
        final Resource item;
        final LinkedSeq rest;

        LinkedSeq(Resource item) {
            this(item, null);
        }

        LinkedSeq(Resource item, LinkedSeq rest) {
            this.item = item;
            this.rest = rest;
        }

        LinkedSeq push(Resource item) {
            return new LinkedSeq(item, this);
        }

        public String toString() {
            StringBuffer result = new StringBuffer("[");
            LinkedSeq scan = this;
            while (scan != null) {
                result.append(scan.item);
                scan = scan.rest;
                result.append(" ");
            }
            return result.append("]").toString();
        }
    }
}

