/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;

public class SerializationContext {
    private Prologue prologue;
    private NodeToLabelMap bNodeMap;

    public SerializationContext(SerializationContext cxt) {
        this.prologue = cxt.prologue;
        this.bNodeMap = cxt.bNodeMap;
    }

    public SerializationContext(Prologue prologue) {
        this(prologue, null);
    }

    public SerializationContext(PrefixMapping prefixMap) {
        this(new Prologue(prefixMap));
    }

    public SerializationContext() {
        this((Prologue)null, null);
    }

    public SerializationContext(PrefixMapping prefixMap, NodeToLabelMap bMap) {
        this(new Prologue(prefixMap), bMap);
    }

    public SerializationContext(Prologue prologue, NodeToLabelMap bMap) {
        this.prologue = prologue;
        if (this.prologue == null) {
            this.prologue = new Prologue();
        }
        this.bNodeMap = bMap;
        if (bMap == null) {
            this.bNodeMap = new NodeToLabelMap("b", false);
        }
    }

    public NodeToLabelMap getBNodeMap() {
        return this.bNodeMap;
    }

    public void setBNodeMap(NodeToLabelMap nodeMap) {
        this.bNodeMap = nodeMap;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prologue.getPrefixMapping();
    }

    public void setPrefixMapping(PrefixMapping prefixMap) {
        this.prologue.setPrefixMapping(prefixMap);
    }

    public void setBaseIRI(String baseIRI) {
        this.prologue.setBaseURI(baseIRI);
    }

    public String getBaseIRI() {
        return this.prologue.getBaseURI();
    }

    public Prologue getPrologue() {
        return this.prologue;
    }
}

