/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.lang.Parser;
import com.hp.hpl.jena.sparql.lang.ParserARQ;
import com.hp.hpl.jena.sparql.lang.ParserFactory;
import com.hp.hpl.jena.sparql.lang.ParserRDQL;
import com.hp.hpl.jena.sparql.lang.ParserSPARQL;
import java.util.HashMap;
import java.util.Map;

public class ParserRegistry {
    Map factories = new HashMap();
    static ParserRegistry registry = null;

    public static ParserRegistry get() {
        if (registry == null) {
            ParserRegistry.init();
        }
        return registry;
    }

    private ParserRegistry() {
    }

    private static void init() {
        registry = new ParserRegistry();
        registry.add(Syntax.syntaxSPARQL, new ParserFactory(){

            public boolean accept(Syntax syntax) {
                return Syntax.syntaxSPARQL.equals(syntax);
            }

            public Parser create(Syntax syntax) {
                return new ParserSPARQL();
            }
        });
        registry.add(Syntax.syntaxARQ, new ParserFactory(){

            public boolean accept(Syntax syntax) {
                return Syntax.syntaxARQ.equals(syntax);
            }

            public Parser create(Syntax syntax) {
                return new ParserARQ();
            }
        });
        registry.add(Syntax.syntaxRDQL, new ParserFactory(){

            public boolean accept(Syntax syntax) {
                return Syntax.syntaxRDQL.equals(syntax);
            }

            public Parser create(Syntax syntax) {
                return new ParserRDQL();
            }
        });
    }

    public static ParserFactory findFactory(Syntax syntax) {
        return ParserRegistry.get().getFactory(syntax);
    }

    public static Parser parser(Syntax syntax) {
        return ParserRegistry.get().createParser(syntax);
    }

    public ParserFactory getFactory(Syntax syntax) {
        return (ParserFactory)this.factories.get(syntax);
    }

    public Parser createParser(Syntax syntax) {
        ParserFactory f = this.getFactory(syntax);
        return f != null ? f.create(syntax) : null;
    }

    public static void addFactory(Syntax syntax, ParserFactory f) {
        ParserRegistry.get().add(syntax, f);
    }

    public void add(Syntax syntax, ParserFactory f) {
        if (!f.accept(syntax)) {
            throw new IllegalArgumentException("The given parser factory does not accept the specified syntax.");
        }
        this.factories.put(syntax, f);
    }

    public static void removeFactory(Syntax syntax) {
        ParserRegistry.get().remove(syntax);
    }

    public void remove(Syntax syntax) {
        this.factories.remove(syntax);
    }

    public static boolean containsParserFactory(Syntax syntax) {
        return ParserRegistry.get().containsFactory(syntax);
    }

    public boolean containsFactory(Syntax syntax) {
        return this.factories.containsKey(syntax);
    }
}

