/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.dataone.client.exception.NotCached;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;

public class LocalCache {
    private JCS dataCache = null;
    private JCS sysmetaCache = null;
    private static LocalCache localCache = null;
    private int hits = 0;
    private int misses = 0;
    private static Log log = LogFactory.getLog(LocalCache.class);

    private LocalCache() {
        try {
            this.dataCache = JCS.getInstance((String)"DATA_CACHE");
            this.sysmetaCache = JCS.getInstance((String)"SYSMETA_CACHE");
        }
        catch (CacheException e) {
            log.error((Object)("Error while creating LocalCache. " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalCache instance() {
        Class<LocalCache> clazz = LocalCache.class;
        synchronized (LocalCache.class) {
            if (null == localCache) {
                localCache = new LocalCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return localCache;
        }
    }

    public void putData(Identifier key, byte[] data) {
        try {
            this.dataCache.put((Object)key, (Object)data);
        }
        catch (CacheException e) {
            log.error((Object)("Error while putting data in LocalCache. " + e.getMessage()));
        }
    }

    public byte[] getData(Identifier key) throws NotCached {
        byte[] cachedData = (byte[])this.dataCache.get((Object)key);
        if (cachedData == null) {
            ++this.misses;
            throw new NotCached("Object not cached: " + key.getValue());
        }
        ++this.hits;
        return cachedData;
    }

    public void putSystemMetadata(Identifier key, SystemMetadata sysmeta) {
        try {
            this.sysmetaCache.put((Object)key, (Object)sysmeta);
        }
        catch (CacheException e) {
            log.error((Object)("Error while putting system metadata in LocalCache. " + e.getMessage()));
        }
    }

    public SystemMetadata getSystemMetadata(Identifier key) throws NotCached {
        SystemMetadata sm = (SystemMetadata)this.sysmetaCache.get((Object)key);
        if (sm == null) {
            ++this.misses;
            throw new NotCached("Object not cached: " + key.getValue());
        }
        ++this.hits;
        return sm;
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public void resetCounters() {
        this.hits = 0;
        this.misses = 0;
    }
}

