% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cme.R
\name{cme}
\alias{cme}
\alias{cme_field_specs}
\title{Get CME SDR data}
\usage{
cme(date, asset_class, field_specs = NULL)

cme_field_specs(asset_class)
}
\arguments{
\item{date}{the date for which data is required as Date or DateTime object.
It will only use the year, month and day elements to
determine the set of trades to return. It will return the set of trades
for the day starting on \code{date}.}

\item{asset_class}{the asset class for which you would like to download trade
data. Valid inputs are  \code{"IR"} (rates), \code{"FX"} (foreign
exchange), \code{"CO"} (commodities). This must be a string.}

\item{field_specs}{a valid column specification that is passed to
\code{\link[readr:read_csv]{readr::read_csv()}} with a default value provided by \code{cme_field_specs()}.
Note that you will likely need to set your own spec as the CME file formats
have changed over time.}
}
\value{
a tibble containing the requested data, or an empty tibble
if data is unavailable
}
\description{
The CME Swap Data Repository (SDR) is a registered U.S. swap data repository
that allows market participants to fulfil their public disclosure
obligations under U.S. legislation. CME is required to make publicly
available price, trading volume and other trading data. It publishes this
data on an FTP site.
}
\examples{
\dontrun{
library(lubridate)
cme(ymd(20150506), "CO")
}
}
\references{
\href{http://www.cmegroup.com/trading/global-repository-services/cme-swap-data-repository.html}{CME SDR}
}
