% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_data}
\alias{add_data}
\title{Add data}
\usage{
add_data(p, data)
}
\arguments{
\item{p}{a datamaps object.}

\item{data}{data.frame.}
}
\description{
Add a dataset.
}
\examples{
coords <- data.frame(city = c("London", "New York", "Beijing", "Sydney"),
                     lon = c(-0.1167218, -73.98002, 116.3883, 151.18518),
                     lat = c(51.49999, 40.74998, 39.92889, -33.92001),
                     values = c(11, 23, 29 , 42))

data <- data.frame(name = c("USA", "FRA", "CHN", "RUS", "COG", "DZA",
                            "BRA", "AFG"),
    color = round(runif(8, 1, 10)))

edges <- data.frame(origin = c("USA", "FRA", "BGD", "ETH", "KHM", "GRD",
                               "FJI", "GNB", "AUT", "YEM"),
    target = c("BRA", "USA", "URY", "ZAF", "SAU", "SVK", "RWA", "SWE",
               "TUV", "ZWE"),
    strokeColor = rep(c("gray", "black"), 5))

data \%>\%
    datamaps(default = "lightgray") \%>\%
    add_choropleth(name, color) \%>\%
    add_data(coords) \%>\%
    add_bubbles(lon, lat, values, values, city, colors = c("skyblue", "darkblue")) \%>\%
    add_data(edges) \%>\%
    add_arcs_name(origin, target, strokeColor)

}
