% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{search_by_spatial}
\alias{search_by_spatial}
\title{Creates a data.frame containing datasets from datos.gob.es}
\usage{
search_by_spatial(spatial1, spatial2, numentry = 50, page = 0)
}
\arguments{
\item{spatial1}{First word of spatial. It can be: "Autonomia", "Pais" or "Provincia"}

\item{spatial2}{Second word of spatial}

\item{numentry}{Number of results for page}

\item{page}{The number of page to see, the first page is 0}
}
\value{
A data.frame
}
\description{
Send a request to datos.gob.es using spatial params
to search datasets that match with the spatial1 and spatial2, then
the results are returned as data.frame
}
\examples{
library(dataesgobr)
\donttest{
datasetsAndalucia <- search_by_spatial('Autonomia', 'Andalucia')
datasetsJaen <- search_by_spatial('Provincia', 'Jaen')
}
}
