% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PageHinkley.R
\name{PageHinkley}
\alias{PageHinkley}
\title{Page-Hinkley Test for Change Detection}
\description{
Implements the Page-Hinkley test, a sequential analysis technique used to detect
changes in the average value of a continuous signal or process. It is effective
in detecting small but persistent changes over time, making it suitable for real-time
monitoring applications.
}
\details{
The Page-Hinkley test is a type of cumulative sum (CUSUM) test that accumulates differences
between data points and a reference value (running mean). It triggers a change detection
signal when the cumulative sum exceeds a predefined threshold. This test is especially
useful for early detection of subtle shifts in the behavior of the monitored process.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
data_part1 <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.7, 0.3))

# Introduce a change in data distribution
data_part2 <- sample(c(0, 5), size = 100, replace = TRUE, prob = c(0.3, 0.7))

# Combine the two parts
data_stream <- c(data_part1, data_part2)
ph <- PageHinkley$new()
for (i in seq_along(data_stream)) {
  ph$add_element(data_stream[i])
  if (ph$detected_change()) {
    cat(sprintf("Change has been detected in data: \%s - at index: \%d\n", data_stream[i], i))
  }
}
}
\references{
E. S. Page. 1954. Continuous Inspection Schemes.
Biometrika 41, 1/2 (1954), 100–115.

Montiel, Jacob, et al. "Scikit-Multiflow: A Multi-output Streaming Framework." Journal of Machine
Learning Research, 2018. This framework provides tools for multi-output and stream data mining
and was an inspiration for some of the implementations in this class.

Implementation: https://github.com/scikit-multiflow/scikit-multiflow/blob/a7e316d1cc79988a6df40da35312e00f6c4eabb2/src/skmultiflow/drift_detection/page_hinkley.py
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{min_instances}}{Minimum number of instances required to start detection.}

\item{\code{delta}}{Minimal change considered significant for detection.}

\item{\code{threshold}}{Decision threshold for signaling a change.}

\item{\code{alpha}}{Forgetting factor for the cumulative sum calculation.}

\item{\code{x_mean}}{Running mean of the observed values.}

\item{\code{sample_count}}{Counter for the number of samples seen.}

\item{\code{sum}}{Cumulative sum used in the change detection.}

\item{\code{change_detected}}{Boolean indicating if a drift has been detected.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PageHinkley-new}{\code{PageHinkley$new()}}
\item \href{#method-PageHinkley-reset}{\code{PageHinkley$reset()}}
\item \href{#method-PageHinkley-add_element}{\code{PageHinkley$add_element()}}
\item \href{#method-PageHinkley-detected_change}{\code{PageHinkley$detected_change()}}
\item \href{#method-PageHinkley-clone}{\code{PageHinkley$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PageHinkley-new"></a>}}
\if{latex}{\out{\hypertarget{method-PageHinkley-new}{}}}
\subsection{Method \code{new()}}{
Initializes the Page-Hinkley test with specific parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PageHinkley$new(
  min_instances = 30,
  delta = 0.005,
  threshold = 50,
  alpha = 1 - 1e-04
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min_instances}}{Minimum number of samples before detection starts.}

\item{\code{delta}}{Change magnitude to trigger detection.}

\item{\code{threshold}}{Cumulative sum threshold for change detection.}

\item{\code{alpha}}{Weight for older data in cumulative sum.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PageHinkley-reset"></a>}}
\if{latex}{\out{\hypertarget{method-PageHinkley-reset}{}}}
\subsection{Method \code{reset()}}{
Resets all the internal states of the detector to initial values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PageHinkley$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PageHinkley-add_element"></a>}}
\if{latex}{\out{\hypertarget{method-PageHinkley-add_element}{}}}
\subsection{Method \code{add_element()}}{
Adds a new element to the data stream and updates the detection status based on the Page-Hinkley test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PageHinkley$add_element(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{New data value to add and evaluate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PageHinkley-detected_change"></a>}}
\if{latex}{\out{\hypertarget{method-PageHinkley-detected_change}{}}}
\subsection{Method \code{detected_change()}}{
Checks if a change has been detected based on the last update.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PageHinkley$detected_change()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean indicating whether a change was detected.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PageHinkley-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PageHinkley-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PageHinkley$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
