% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{kvApply}
\alias{kvApply}
\title{Apply Function to Key-Value Pair}
\usage{
kvApply(kvPair, fn)
}
\arguments{
\item{kvPair}{a key-value pair (a list with 2 elements or object created with \code{\link{kvPair}})}

\item{fn}{a function}
}
\description{
Apply a function to a single key-value pair - not a traditional R "apply" function.
}
\details{
Determines how a function should be applied to a key-value pair and then applies it: if the function has two formals, it applies the function giving it the key and the value as the arguments; if the function has one formal, it applies the function giving it just the value.  The function is assumed to return a value unless the result is a \code{\link{kvPair}} object.  When the function returns a value the original key will be returned in the resulting key-value pair.

This provides flexibility and simplicity for when a function is only meant to be applied to the value (the most common case), but still allows keys to be used if desired.
}
\examples{
kv <- kvPair(1, 2)
kv
kvApply(kv, function(x) x^2)
kvApply(kv, function(k, v) v^2)
kvApply(kv, function(k, v) k + v)
kvApply(kv, function(x) kvPair("new_key", x))
}

