% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conn_localDisk.R
\name{charFileHash}
\alias{charFileHash}
\title{Character File Hash Function}
\usage{
charFileHash(keys, conn)
}
\arguments{
\item{keys}{keys to be hashed}

\item{conn}{a "localDiskConn" object}
}
\description{
Function to be used to specify the file where key-value pairs get stored for local disk connections, useful when keys are scalar strings.  Should be passed as the argument \code{fileHashFn} to \code{\link{localDiskConn}}.
}
\details{
You shouldn't need to call this directly other than to experiment with what the output looks like or to get ideas on how to write your own custom hash.
}
\examples{
# connect to empty localDisk directory
path <- file.path(tempdir(), "irisSplit")
unlink(path, recursive = TRUE)
conn <- localDiskConn(path, autoYes = TRUE, fileHashFn = charFileHash)
# add some data
addData(conn, list(list("key1", iris[1:10,])))
addData(conn, list(list("key2", iris[11:110,])))
addData(conn, list(list("key3", iris[111:150,])))
# see that files were stored by their key
list.files(path)
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{localDiskConn}}, \code{\link{digestFileHash}}
}

