% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/readNWISunit.r
\name{readNWISpeak}
\alias{readNWISpeak}
\title{Peak flow data from USGS (NWIS)}
\usage{
readNWISpeak(siteNumbers, startDate = "", endDate = "", asDateTime = TRUE)
}
\arguments{
\item{siteNumbers}{character USGS site number(or multiple sites).  This is usually an 8 digit number.}

\item{startDate}{character starting date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the earliest possible record.}

\item{endDate}{character ending date for data retrieval in the form YYYY-MM-DD. Default is "" which indicates
retrieval for the latest possible record.}

\item{asDateTime}{logical default to \code{TRUE}. When \code{TRUE}, the peak_dt column is converted
to a Date object, and incomplete dates are removed. When \code{FALSE}, no columns are removed, but no dates are converted.}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency_cd \tab character \tab The NWIS code for the agency reporting the data\cr
site_no \tab character \tab The USGS site number \cr
peak_dt \tab Date \tab Date of peak streamflow \cr
peak_tm \tab character \tab Time of peak streamflow as character \cr
peak_va \tab numeric \tab Annual peak streamflow value in cfs \cr
peak_cd \tab character \tab Peak Discharge-Qualification codes (see \code{comment} for more information) \cr
gage_ht \tab numeric \tab Gage height for the associated peak streamflow in feet \cr
gage_ht_cd \tab character \tab Gage height qualification codes \cr
year_last_pk \tab character \tab Peak streamflow reported is the highest since this year \cr
ag_dt \tab character \tab Date of maximum gage-height for water year (if not concurrent with peak) \cr
ag_tm \tab character \tab Time of maximum gage-height for water year (if not concurrent with peak) \cr
ag_gage_ht \tab character \tab maximum Gage height for water year in feet (if not concurrent with peak) \cr
ag_gage_ht_cd \tab character \tab maximum Gage height code \cr
}

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
comment \tab character \tab Header comments from the RDB file \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
}
}
\description{
Reads peak flow from NWISweb. Data is retrieved from \url{http://waterdata.usgs.gov/nwis}.
In some cases, the specific date of the peak data is not know. This function will default to
converting the complete dates, dropping rows with incomplete dates. If those incomplete dates are
needed, set the `asDateTime` argument to FALSE. No rows will be removed, and no dates will be converted
to R Date objects.
}
\examples{
siteNumbers <- c('01594440','040851325')
\dontrun{
data <- readNWISpeak(siteNumbers)
}
}
\seealso{
\code{\link{constructNWISURL}}, \code{\link{importRDB1}}
}

