% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_col_as.R
\name{set_col_as_date}
\alias{set_col_as_date}
\title{Set columns as POSIXct}
\usage{
set_col_as_date(data_set, cols = NULL, format = NULL, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of data_set to transform into dates}

\item{format}{Date's format (function will be faster if the format is provided)
(character or list of character, default to NULL).\cr
For timestamps, format need to be provided ("s" or "ms" or second or millisecond timestamps)}

\item{verbose}{Should the function log (logical, default to TRUE)}
}
\value{
\code{data_set} (as a \code{\link{data.table}}), with specified columns set as Date.
If the transformation generated only NA, the column is set back to its original value.
}
\description{
Set as POSIXct a character column (or a list of columns) from a data.table.
}
\details{
set_col_as_date is way faster when format is provided. If you want to identify dates and format
automatically, have a look to \code{\link{identify_dates}}. \cr
If input column is a factor, it will be returned as a POSIXct column. \cr
If \code{cols} is kept to default (NULL) set_col_as_date won't do anything.
}
\examples{
# Lets build a data_set set
data_set <- data.frame(ID = seq_len(5),
                  date1 = c("2015-01-01", "2016-01-01", "2015-09-01", "2015-03-01", "2015-01-31"),
                  date2 = c("2015_01_01", "2016_01_01", "2015_09_01", "2015_03_01", "2015_01_31")
                  )

# Using set_col_as_date for date2
data_transformed <- set_col_as_date(data_set, cols = "date2", format = "\%Y_\%m_\%d")

# Control the results
lapply(data_transformed, class)

# With multiple formats:
data_transformed <- set_col_as_date(data_set, format = list(date1 = "\%Y-\%m-\%d", date2 = "\%Y_\%m_\%d"))
lapply(data_transformed, class)

# It also works with timestamps
data_set <- data.frame(time_stamp = c(1483225200, 1485990000, 1488495600))
set_col_as_date(data_set, cols = "time_stamp", format = "s")
}
