% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFromCharacter.R
\name{generateFromCharacter}
\alias{generateFromCharacter}
\title{Recode character}
\usage{
generateFromCharacter(dataSet, cols = "auto", verbose = TRUE,
  drop = FALSE, ...)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{List of character column(s) name(s) of dataSet to transform. To transform all 
characters, set it to "auto". (character, default to "auto")}

\item{verbose}{Should the function log (logical, default to TRUE)}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\value{
\code{dataSet} with new columns. \code{dataSet} is edited by \strong{reference}.
}
\description{
Recode character into 3 new columns: \cr
\itemize{
\item was the value not NA, "NA", "",
\item how often this value occures,
\item the order of the value (ex: M/F => 2/1 because F comes before M in alphabet).
}
}
\examples{
# Load data set
data(messy_adult)
messy_adult <- unFactor(messy_adult, verbose = FALSE) # un factor ugly factors

# transform column "mail"
messy_adult <- generateFromCharacter(messy_adult, cols = "mail")
head(messy_adult)

# To transform all characters columns:
messy_adult <- generateFromCharacter(messy_adult, cols = "auto")
}
