% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeSet.R
\name{shapeSet}
\alias{shapeSet}
\title{Final preparation before ML algorithm}
\usage{
shapeSet(dataSet, finalForm = "data.table", thresh = 10, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{finalForm}{"data.table" or "numerical_matrix" (default to data.table)}

\item{thresh}{numeric, threshold such that  a numerical column is transformed into
  a factor whenever its number of unique modalities is smaller or equal to
\code{thresh} (default to 10)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\description{
Prepare a data.table by: \cr
- transforming numeric variables into factors whenever they take less than \code{thresh} unique 
variables \cr
- transforming characters using \code{generateFromCharacter} \cr
- transforming logical into binary integers \cr
- dropping constant columns \cr
- Sending the data.table to setAsNumericMatrix() (when finalForm == "numerical_matrix") will then allow 
you to get a numerical matrix usable by most Machine Learning Algorithms.
}
\section{Warning}{

All these changes will happen \strong{by reference}.
}

