% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.utils.fdsim.r
\name{gl.utils.fdsim}
\alias{gl.utils.fdsim}
\title{Estimate the rate of false positives in a fixed difference analysis}
\usage{
gl.utils.fdsim(gl, poppair, obs = NULL, reps = 1000, delta = 0.02,
  v = 2)
}
\arguments{
\item{gl}{-- name of the genlight containing the SNP genotypes [required]}

\item{poppair}{-- labels of two populations for comparison in the form c(popA,popB) [required]}

\item{obs}{-- observed number of fixed differences between the two populations [required]}

\item{reps}{-- number of replications to undertake in the simulation [default 1000]}

\item{delta}{-- the threshold value for the minor allele frequency to regard the difference between two populations to be fixed [default 0.02]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A list containing the following square matricies
        [[1]] observed fixed differences;
        [[2]] mean expected number of false positives for each comparison;
        [[3]] standard deviation of the no. of false positives for each comparison;
        [[4]] probability the observed fixed differences arose by chance for each comparison;
}
\description{
This is a support script, called by gl.collapse.recursive.
The script takes two populations and generates allele frequency profiles for them. It then samples an allele frequency for each, at random, and estimates a sampling distribution for those two allele frequencies. Drawing two samples from those sampling distributions, it calculates whether or not they represent a fixed difference. This is applied to all loci, and the number of fixed differences so
generated are counted, as an expectation. The script distinguished between true fixed differences (with a tolerance of delta), and false positives. The simulation is repeated a given number of times (default=1000) to provide an expectation of the number of false positives, given the observed allele frequency profiles and the sample sizes. The probability of the observed count of fixed differences is greater than the expected number of false positives is calculated.
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
